/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.selection;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import si.ijs.kt.clus.data.type.primitive.IndexAttrType;
import si.ijs.kt.clus.selection.XValMainSelection;
import si.ijs.kt.clus.util.exception.ClusException;

public class XValDataSelection
extends XValMainSelection {
    protected IndexAttrType m_Attr;

    public XValDataSelection(IndexAttrType type) {
        super(type.getMaxValue(), type.getNbRows());
        this.m_Attr = type;
    }

    @Override
    public int getFold(int row) {
        return this.m_Attr.getValue(row) - 1;
    }

    public static XValDataSelection readFoldsFile(String fname, int nbrows) throws IOException, ClusException {
        IndexAttrType attr = new IndexAttrType("XVAL");
        attr.setNbRows(nbrows);
        for (int i = 0; i < nbrows; ++i) {
            attr.setValue(i, -1);
        }
        int fold = 0;
        try (LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));){
            String line = rdr.readLine();
            while (line != null) {
                if (!(line = line.trim()).equals("")) {
                    ++fold;
                    String[] tokens = line.split("[\\,\\s]+");
                    for (int j = 0; j < tokens.length; ++j) {
                        try {
                            int exid = Integer.parseInt(tokens[j]);
                            if (attr.getValue(exid) != -1) {
                                throw new ClusException("Example id " + exid + " occurs twice in folds file: " + fname);
                            }
                            attr.setValue(exid, fold);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ClusException("Illegal number: " + tokens[j] + " in folds file: " + fname);
                        }
                    }
                }
                line = rdr.readLine();
            }
        }
        for (int i = 0; i < nbrows; ++i) {
            if (attr.getValue(i) != -1) continue;
            throw new ClusException("Folds file does not define fold for example " + (i + 1) + ": " + fname);
        }
        return new XValDataSelection(attr);
    }
}

