/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.selection;

import si.ijs.kt.clus.selection.BagSelection;
import si.ijs.kt.clus.selection.ClusSelection;

public class OOBSelection
extends ClusSelection {
    protected int[] m_OOBCounts;
    protected int m_OOBNbSel;

    public OOBSelection(BagSelection bsel) {
        super(bsel.getNbRows());
        this.m_OOBCounts = new int[bsel.getNbRows()];
        this.m_OOBNbSel = 0;
        for (int i = 0; i < bsel.getNbRows(); ++i) {
            if (bsel.getWeight(i) != 0.0) continue;
            this.m_OOBCounts[i] = 1;
            ++this.m_OOBNbSel;
        }
        if (this.m_OOBNbSel != bsel.getNbRows() - bsel.getNbSelected()) {
            System.err.println(this.getClass().getName() + ": Error while creating the OOB");
        }
    }

    @Override
    public boolean changesDistribution() {
        return true;
    }

    @Override
    public double getWeight(int row) {
        return this.m_OOBCounts[row];
    }

    public int[] getOOBCounts() {
        return this.m_OOBCounts;
    }

    @Override
    public int getNbSelected() {
        return this.m_OOBNbSel;
    }

    @Override
    public boolean isSelected(int row) {
        return this.m_OOBCounts[row] != 0;
    }

    public final int getCount(int row) {
        return this.m_OOBCounts[row];
    }

    public void addToThis(OOBSelection other) {
        for (int i = 0; i < this.m_OOBCounts.length; ++i) {
            if (this.getWeight(i) != 0.0 || other.getWeight(i) != 1.0) continue;
            this.m_OOBCounts[i] = 1;
            ++this.m_OOBNbSel;
        }
    }

    public void addToOther(OOBSelection other) {
        for (int i = 0; i < this.m_OOBCounts.length; ++i) {
            if (this.getWeight(i) != 1.0 || other.getWeight(i) != 0.0) continue;
            other.m_OOBCounts[i] = 1;
            ++other.m_OOBNbSel;
        }
    }
}

