/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.selection;

import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.ClusRandomNonstatic;

public class BagSelection
extends ClusSelection {
    protected int[] m_Counts;
    protected int m_NbSel;

    public BagSelection(int nbrows) {
        super(nbrows);
    }

    public BagSelection(int nbrows, int nbselected, ClusRandomNonstatic rnd) {
        super(nbrows);
        int i;
        this.m_Counts = new int[nbrows];
        if (nbselected == 0) {
            nbselected = nbrows;
        }
        if (rnd == null) {
            for (i = 0; i < nbselected; ++i) {
                int n = ClusRandom.nextInt(1, nbrows);
                this.m_Counts[n] = this.m_Counts[n] + 1;
            }
        } else {
            for (i = 0; i < nbselected; ++i) {
                int n = rnd.nextInt(3, nbrows);
                this.m_Counts[n] = this.m_Counts[n] + 1;
            }
        }
        for (i = 0; i < nbrows; ++i) {
            if (this.m_Counts[i] == 0) continue;
            ++this.m_NbSel;
        }
    }

    @Override
    public boolean changesDistribution() {
        return true;
    }

    @Override
    public double getWeight(int row) {
        return this.m_Counts[row];
    }

    @Override
    public int getNbSelected() {
        return this.m_NbSel;
    }

    @Override
    public boolean isSelected(int row) {
        return this.m_Counts[row] != 0;
    }

    public final int getCount(int row) {
        return this.m_Counts[row];
    }
}

