/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.pruning;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class M5Pruner
extends PruneTree {
    double m_PruningMult = 2.0;
    double m_GlobalDeviation;
    ClusAttributeWeights m_ClusteringWeights;
    RowData m_TrainingData;

    public M5Pruner(ClusAttributeWeights prod, double mult) {
        this.m_ClusteringWeights = prod;
        this.m_PruningMult = mult;
    }

    @Override
    public void prune(ClusNode node) {
        ClusStatistic stat = node.getClusteringStat();
        this.m_GlobalDeviation = Math.sqrt(stat.getSVarS(this.m_ClusteringWeights) / stat.getTotalWeight());
        this.pruneRecursive(node);
    }

    @Override
    public int getNbResults() {
        return 1;
    }

    private double pruningFactor(double num_instances, int num_params) {
        if (num_instances <= (double)num_params) {
            return 10.0;
        }
        return (num_instances + this.m_PruningMult * (double)num_params) / (num_instances - (double)num_params);
    }

    public void pruneRecursive(ClusNode node) {
        double rmsSubTree;
        double adjustedErrorTree;
        if (node.atBottomLevel()) {
            return;
        }
        for (int i = 0; i < node.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)node.getChild(i);
            this.pruneRecursive(child);
        }
        ClusStatistic stat = node.getClusteringStat();
        double rmsLeaf = Math.sqrt(stat.getSVarS(this.m_ClusteringWeights) / stat.getTotalWeight());
        double adjustedErrorLeaf = rmsLeaf * this.pruningFactor(stat.getTotalWeight(), 1);
        if (adjustedErrorLeaf <= (adjustedErrorTree = (rmsSubTree = Math.sqrt(node.estimateClusteringSS(this.m_ClusteringWeights) / stat.getTotalWeight())) * this.pruningFactor(stat.getTotalWeight(), node.getModelSize())) || adjustedErrorLeaf < this.m_GlobalDeviation * 1.0E-5) {
            node.makeLeaf();
        }
    }

    @Override
    public void setTrainingData(RowData data) {
        this.m_TrainingData = data;
    }
}

