/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.pruning;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class BottomUpPruningVSB
extends PruneTree {
    protected ClusError m_TreeErr;
    protected ClusError m_NodeErr;
    protected RowData m_Data;

    public BottomUpPruningVSB(ClusErrorList parent, RowData data) throws ClusException {
        this.m_TreeErr = parent.getFirstError();
        this.m_NodeErr = this.m_TreeErr.getErrorClone(parent);
        this.m_Data = data;
    }

    @Override
    public int getNbResults() {
        return 1;
    }

    @Override
    public void prune(ClusNode node) throws ClusException {
        this.prune(node, this.m_Data);
    }

    public void prune(ClusNode node, RowData data) throws ClusException {
        if (!node.atBottomLevel()) {
            int arity = node.getNbChildren();
            for (int i = 0; i < arity; ++i) {
                RowData subset = data.applyWeighted(node.getTest(), i);
                this.prune((ClusNode)node.getChild(i), subset);
            }
            int nbrows = data.getNbRows();
            if (nbrows > 0) {
                this.m_TreeErr.reset();
                this.m_NodeErr.reset();
                this.m_TreeErr.getParent().setNbExamples(0);
                for (int i = 0; i < nbrows; ++i) {
                    DataTuple tuple = data.getTuple(i);
                    ClusStatistic pred = node.predictWeighted(tuple);
                    this.m_TreeErr.addExample(tuple, pred);
                    this.m_NodeErr.addExample(tuple, node.predictWeightedLeaf(tuple));
                }
                this.m_TreeErr.getParent().setNbExamples(nbrows);
                double tree_err = this.m_TreeErr.getModelError();
                double node_err = this.m_NodeErr.getModelError();
                if (this.m_TreeErr.shouldBeLow()) {
                    if (tree_err > node_err) {
                        node.makeLeaf();
                    }
                } else if (tree_err <= node_err) {
                    node.makeLeaf();
                }
            } else {
                node.makeLeaf();
            }
        }
    }
}

