/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class PredictionWriter
extends ClusModelProcessor {
    protected String m_Fname;
    protected PrintWriter m_Writer;
    protected MyArray m_Attrs;
    protected boolean m_Global;
    protected Settings m_Sett;
    protected StringBuffer m_ModelParts;
    protected ClusSchema m_OutSchema;
    protected ClusStatistic m_Target;
    protected boolean m_Initialized;
    protected String m_ToPrint;
    protected ArrayList m_ModelNames = new ArrayList();
    protected HashSet m_ModelNamesMap = new HashSet();

    public PredictionWriter(String fname, Settings sett, ClusStatistic target) {
        this.m_Fname = fname;
        this.m_Sett = sett;
        this.m_Target = target;
        this.m_ModelParts = new StringBuffer();
    }

    @Override
    public boolean shouldProcessModel(ClusModelInfo info) {
        return info.shouldWritePredictions() && !info.getName().equals("Default");
    }

    @Override
    public void addModelInfo(ClusModelInfo info) {
        if (!this.m_ModelNamesMap.contains(info.getName())) {
            this.m_ModelNamesMap.add(info.getName());
            this.m_ModelNames.add(info.getName());
        }
    }

    public void addTargetAttributesForEachModel() {
        for (int i = 0; i < this.m_ModelNames.size(); ++i) {
            String mn = (String)this.m_ModelNames.get(i);
            this.m_Target.addPredictWriterSchema(mn, this.m_OutSchema);
            this.m_OutSchema.addAttrType(new StringAttrType(mn + "-models"));
        }
    }

    public void println(String line) {
        if (this.m_Initialized) {
            this.m_Writer.println(line);
        } else {
            this.m_ToPrint = line;
        }
    }

    @Override
    public void initializeAll(ClusSchema schema) throws IOException, ClusException {
        if (this.m_Initialized) {
            return;
        }
        if (!this.m_Global) {
            this.doInitialize(schema);
        }
        this.addTargetAttributesForEachModel();
        ClusLogger.info("PredictionWriter is writing the ARFF header");
        ARFFFile.writeArffHeader(this.m_Writer, this.m_OutSchema);
        this.m_Writer.println("@DATA");
        if (this.m_ToPrint != null) {
            this.m_Writer.println(this.m_ToPrint);
            this.m_ToPrint = null;
        }
        this.m_Initialized = true;
    }

    @Override
    public void terminateAll() throws IOException {
        if (!this.m_Global) {
            this.close();
        }
    }

    public void globalInitialize(ClusSchema schema) throws IOException, ClusException {
        this.m_Global = true;
        this.doInitialize(schema);
    }

    public PrintWriter getWrt() {
        return this.m_Writer;
    }

    public void close() throws IOException {
        this.m_Writer.close();
    }

    @Override
    public boolean needsModelUpdate() {
        return true;
    }

    @Override
    public void modelUpdate(DataTuple tuple, ClusModel model) throws IOException {
        if (this.m_ModelParts.length() != 0) {
            this.m_ModelParts.append("+");
        }
        this.m_ModelParts.append(String.valueOf(model.getID()));
    }

    @Override
    public void exampleUpdate(DataTuple tuple) {
        for (int j = 0; j < this.m_Attrs.size(); ++j) {
            if (j != 0) {
                this.m_Writer.print(",");
            }
            ClusAttrType at = (ClusAttrType)this.m_Attrs.elementAt(j);
            this.m_Writer.print(at.getPredictionWriterString(tuple));
        }
    }

    @Override
    public void exampleDone() {
        this.m_Writer.println();
        this.m_ModelParts.setLength(0);
    }

    @Override
    public void flushWriter() {
        this.m_Writer.flush();
    }

    @Override
    public void exampleUpdate(DataTuple tuple, ClusStatistic distr) throws ClusException {
        this.m_Writer.print(",");
        if (distr == null) {
            this.m_Writer.print("???");
        } else {
            this.m_Writer.print(distr.getPredictWriterString(tuple));
        }
        this.m_Writer.print(",\"" + this.m_ModelParts + "\"");
        this.m_ModelParts.setLength(0);
    }

    private void doInitialize(ClusSchema schema) throws IOException, ClusException {
        ClusAttrType at;
        int i;
        this.m_Attrs = new MyArray();
        int nb = schema.getNbAttributes();
        this.m_OutSchema = new ClusSchema(StringUtils.removeSingleQuote(schema.getRelationName()) + "-predictions");
        this.m_OutSchema.setSettings(schema.getSettings());
        for (i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            this.m_Attrs.addElement(at);
            this.m_OutSchema.addAttrType(at.cloneType());
        }
        for (i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
            this.m_Attrs.addElement(at);
            at.updatePredictWriterSchema(this.m_OutSchema);
        }
        this.m_Writer = this.m_Sett.getGeneric().getFileAbsoluteWriter(this.m_Fname);
    }
}

