/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model.processor;

import java.io.IOException;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class ClusModelProcessor {
    public boolean shouldProcessModel(ClusModelInfo info) {
        return true;
    }

    public void addModelInfo(ClusModelInfo info) {
    }

    public void initialize(ClusModel model, ClusSchema schema) throws IOException, ClusException {
    }

    public void initializeAll(ClusSchema schema) throws IOException, ClusException {
    }

    public void terminate(ClusModel model) throws IOException, ClusException {
    }

    public void terminateAll() throws IOException {
    }

    public void exampleUpdate(DataTuple tuple) throws IOException {
    }

    public void exampleDone() throws IOException {
    }

    public void flushWriter() {
    }

    public void exampleUpdate(DataTuple tuple, ClusStatistic distr) throws IOException, ClusException {
    }

    public void modelUpdate(DataTuple tuple, ClusModel model) throws IOException, ClusException {
    }

    public void modelDone() throws IOException {
    }

    public boolean needsModelUpdate() {
        return false;
    }

    public boolean needsInternalNodes() {
        return false;
    }
}

