/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.model;

import java.io.IOException;
import java.io.Serializable;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.processor.ClusEnsemblePredictionWriter;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.model.processor.ModelProcessorCollection;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusModelInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int TRAIN_ERR = 0;
    public static final int TEST_ERR = 1;
    public static final int VALID_ERR = 2;
    public static final int XVAL_PREDS = 3;
    protected String m_Name;
    protected boolean m_HasName = false;
    protected boolean m_ShouldSave = true;
    protected boolean m_ShouldWritePredictions = true;
    protected boolean m_ShouldPruneInvalid;
    protected int m_ModelSize;
    protected int m_NbModels;
    protected double m_Score;
    protected ClusModel m_Model;
    public ClusErrorList m_TrainErr;
    public ClusErrorList m_TestErr;
    public ClusErrorList m_ValidErr;
    public ClusErrorList m_ExtraErr;
    protected ClusStatManager m_Manager;
    protected transient ModelProcessorCollection m_TrainModelProc;
    protected transient ModelProcessorCollection m_TestModelProc;
    protected transient ModelProcessorCollection m_ValidModelProc;
    protected transient ClusEnsemblePredictionWriter m_TrainPreds;
    protected transient ClusEnsemblePredictionWriter m_TestPreds;

    public ClusModelInfo(String name) {
        this.m_Name = name;
        this.m_HasName = false;
    }

    public void setAllErrorsClone(ClusErrorList train, ClusErrorList test, ClusErrorList valid) throws ClusException {
        this.m_TrainErr = null;
        this.m_TestErr = null;
        this.m_ValidErr = null;
        if (train != null) {
            this.m_TrainErr = train.getErrorClone();
        }
        if (test != null) {
            this.m_TestErr = test.getErrorClone();
        }
        if (valid != null) {
            this.m_ValidErr = valid.getErrorClone();
        }
    }

    public void setSelectedErrorsClone(ClusErrorList train, ClusErrorList test, ClusErrorList valid) throws ClusException {
        this.m_TrainErr = null;
        this.m_TestErr = null;
        this.m_ValidErr = null;
        if (train != null) {
            this.m_TrainErr = train.getErrorClone(this.getName());
        }
        if (test != null) {
            this.m_TestErr = test.getErrorClone(this.getName());
        }
        if (valid != null) {
            this.m_ValidErr = valid.getErrorClone(this.getName());
        }
    }

    public final String getName() {
        return this.m_Name;
    }

    public final ClusModel getModel() {
        return this.m_Model;
    }

    public final double getScore() {
        return this.m_Score;
    }

    public ClusStatManager getStatManager() {
        return this.m_Manager;
    }

    public ClusSchema getSchema() {
        return this.m_Manager.getSchema();
    }

    public Settings getSettings() {
        return this.m_Manager.getSettings();
    }

    public final ClusErrorList getTrainingError() {
        return this.m_TrainErr;
    }

    public final ClusErrorList getTestError() {
        return this.m_TestErr;
    }

    public final ClusErrorList getValidationError() {
        return this.m_ValidErr;
    }

    public void setStatManager(ClusStatManager mgr) {
        this.m_Manager = mgr;
    }

    public final void setScore(double score) {
        this.m_Score = score;
    }

    public void check() throws ClusException {
        throw new ClusException("MI = " + this.m_TestErr);
    }

    public void clearAll() {
        this.m_TrainModelProc = null;
        this.m_TestModelProc = null;
    }

    public final void addModelProcessor(int type, ClusModelProcessor proc) {
        ModelProcessorCollection coll = this.getAddModelProcessors(type);
        coll.addModelProcessor(proc);
    }

    public final void addEnsemblePredictionWriter(int type, ClusEnsemblePredictionWriter wrtr) {
        if (type == 1) {
            this.m_TestPreds = wrtr;
        }
        if (type == 0) {
            this.m_TrainPreds = wrtr;
        }
    }

    public final void addCheckModelProcessor(int type, ClusModelProcessor proc) {
        ModelProcessorCollection coll = this.getAddModelProcessors(type);
        if (coll.addCheckModelProcessor(proc)) {
            proc.addModelInfo(this);
        }
    }

    public final ModelProcessorCollection getAddModelProcessors(int type) {
        if (type == 0) {
            if (this.m_TrainModelProc == null) {
                this.m_TrainModelProc = new ModelProcessorCollection();
            }
            return this.m_TrainModelProc;
        }
        if (type == 1) {
            if (this.m_TestModelProc == null) {
                this.m_TestModelProc = new ModelProcessorCollection();
            }
            return this.m_TestModelProc;
        }
        if (this.m_ValidModelProc == null) {
            this.m_ValidModelProc = new ModelProcessorCollection();
        }
        return this.m_ValidModelProc;
    }

    public final ModelProcessorCollection getModelProcessors(int type) {
        if (type == 0) {
            return this.m_TrainModelProc;
        }
        if (type == 1) {
            return this.m_TestModelProc;
        }
        return this.m_ValidModelProc;
    }

    public final ClusEnsemblePredictionWriter getEnsemblePredictionWriter(int type) {
        if (type == 1) {
            return this.m_TestPreds;
        }
        if (type == 0) {
            return this.m_TrainPreds;
        }
        return null;
    }

    public final void initEnsemblePredictionWriter(int type) {
        String fname = "";
        if (type == 1 && this.m_TestPreds == null) {
            fname = this.getSettings().getGeneric().getAppName() + ".ens.test.preds";
            this.m_TestPreds = new ClusEnsemblePredictionWriter(fname, this.getSchema(), this.getSettings());
        }
        if (type == 0 && this.m_TrainPreds == null) {
            fname = this.getSettings().getGeneric().getAppName() + ".ens.train.preds";
            this.m_TrainPreds = new ClusEnsemblePredictionWriter(fname, this.getSchema(), this.getSettings());
        }
    }

    public final void initModelProcessors(int type, ClusSchema schema) throws IOException, ClusException {
        ModelProcessorCollection coll = this.getModelProcessors(type);
        if (coll != null) {
            coll.initialize(this.m_Model, schema);
        }
    }

    public final void initAllModelProcessors(int type, ClusSchema schema) throws IOException, ClusException {
        ModelProcessorCollection coll = this.getModelProcessors(type);
        if (coll != null) {
            coll.initializeAll(schema);
        }
    }

    public final void termModelProcessors(int type) throws IOException, ClusException {
        ModelProcessorCollection coll = this.getModelProcessors(type);
        if (coll != null) {
            coll.terminate(this.m_Model);
        }
    }

    public final void termAllModelProcessors(int type) throws IOException {
        ModelProcessorCollection coll = this.getModelProcessors(type);
        if (coll != null) {
            coll.terminateAll();
        }
    }

    public final void terminateEnsemblePredictionWriter(int type) {
        if (type == 1) {
            this.m_TestPreds.closeWriter();
        }
        if (type == 0) {
            this.m_TrainPreds.closeWriter();
        }
    }

    public final void copyModelProcessors(ClusModelInfo target) {
        this.copyModelProcessors(0, target);
        this.copyModelProcessors(1, target);
    }

    public final void copyModelProcessors(int type, ClusModelInfo target) {
        ModelProcessorCollection coll = this.getModelProcessors(type);
        if (coll == null) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            ClusModelProcessor mproc = coll.getModelProcessor(i);
            if (!mproc.shouldProcessModel(target)) continue;
            target.addCheckModelProcessor(type, mproc);
        }
    }

    public final ClusModelInfo cloneModelInfo() throws ClusException {
        ClusModelInfo clone = new ClusModelInfo(this.m_Name);
        clone.setAllErrorsClone(this.m_TrainErr, this.m_TestErr, this.m_ValidErr);
        clone.setShouldSave(this.m_ShouldSave);
        clone.setShouldWritePredictions(this.m_ShouldWritePredictions);
        clone.setPruneInvalid(this.m_ShouldPruneInvalid);
        return clone;
    }

    public final void setModel(ClusModel model) {
        this.m_Model = model;
    }

    public final void deleteModel() {
        this.m_Model = null;
    }

    public final void setTestError(ClusErrorList err) {
        this.m_TestErr = err;
    }

    public final void setTrainError(ClusErrorList err) {
        this.m_TrainErr = err;
    }

    public final void setValidationError(ClusErrorList err) {
        this.m_ValidErr = err;
    }

    public void setExtraError(int type, ClusErrorList parent) {
        this.m_ExtraErr = parent;
    }

    public boolean hasExtraError(int type) {
        return this.m_ExtraErr != null;
    }

    public ClusErrorList getExtraError(int type) {
        return this.m_ExtraErr;
    }

    public final void setName(String name) {
        this.m_Name = name;
        this.m_HasName = true;
    }

    public final boolean hasName() {
        return this.m_HasName;
    }

    public final void setShouldSave(boolean save) {
        this.m_ShouldSave = save;
    }

    public final boolean shouldSave() {
        return this.m_ShouldSave;
    }

    public boolean shouldWritePredictions() {
        return this.m_ShouldWritePredictions;
    }

    public void setShouldWritePredictions(boolean value) {
        this.m_ShouldWritePredictions = value;
    }

    public final void setPruneInvalid(boolean prune) {
        this.m_ShouldPruneInvalid = prune;
    }

    public final boolean shouldPruneInvalid() {
        return this.m_ShouldPruneInvalid;
    }

    public final ClusErrorList getError(int traintest) {
        if (traintest == 0) {
            return this.m_TrainErr;
        }
        if (traintest == 2) {
            return this.m_ValidErr;
        }
        if (traintest == 1) {
            return this.m_TestErr;
        }
        return null;
    }

    public final ClusErrorList getCreateTestError() throws ClusException {
        if (this.m_TestErr == null) {
            this.m_TestErr = this.m_TrainErr.getErrorClone();
        }
        return this.m_TestErr;
    }

    public final boolean hasTestError() {
        return this.m_TestErr != null;
    }

    public final boolean hasTrainError() {
        return this.m_TrainErr != null;
    }

    public final boolean hasValidError() {
        return this.m_ValidErr != null;
    }

    public final String getModelInfo() throws InterruptedException {
        if (this.m_Model == null) {
            return "No model available";
        }
        return this.m_Model.getModelInfo();
    }

    public final int getModelSize() {
        if (this.m_Model == null) {
            return this.m_ModelSize;
        }
        return this.m_Model.getModelSize();
    }

    public final int getNbModels() {
        if (this.m_Model == null) {
            return this.m_NbModels;
        }
        return 1;
    }

    public final boolean hasModel() {
        return this.getNbModels() > 0;
    }

    public final void updateName(ClusModelInfo other) throws ClusException {
        if (this.hasName()) {
            if (other.hasName() && !this.getName().equals(other.getName())) {
                throw new ClusException("Combining error measures of different models: " + this.getName() + " <> " + other.getName());
            }
        } else if (other.hasName()) {
            this.setName(other.getName());
        }
    }

    public final void add(ClusModelInfo other) throws ClusException {
        this.updateName(other);
        this.m_ModelSize += other.getModelSize();
        this.m_NbModels += other.getNbModels();
        if (other.hasTrainError()) {
            this.m_TrainErr.add(other.getTrainingError());
        }
        if (other.hasValidError()) {
            this.m_ValidErr.add(other.getValidationError());
        }
        if (other.hasTestError()) {
            ClusErrorList mytesterr = this.getCreateTestError();
            mytesterr.add(other.getTestError());
        }
    }

    public String toString() {
        return "ModelInfo '" + this.getName() + "' Size: " + this.getModelSize();
    }
}

