/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.Arrays;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsAttribute;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileStringOrInt;

public class SettingsRules
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileBool m_PrintAllRules;
    private boolean IS_RULE_SIG_TESTING = false;
    private INIFileEnum<CoveringMethod> m_CoveringMethod;
    private INIFileEnum<RulePredictionMethod> m_PredictionMethod;
    private INIFileEnum<RuleAddingMethod> m_RuleAddingMethod;
    private INIFileEnum<InitialRuleGeneratingMethod> m_InitialRuleGeneratingMethod;
    private INIFileDouble m_CoveringWeight;
    private INIFileDouble m_InstCoveringWeightThreshold;
    private INIFileInt m_MaxRulesNb;
    private INIFileDouble m_HeurDispOffset;
    private INIFileDouble m_HeurCoveragePar;
    private INIFileDouble m_HeurRuleDistPar;
    private INIFileDouble m_HeurPrototypeDistPar;
    private INIFileDouble m_RuleSignificanceLevel;
    private INIFileInt m_RuleNbSigAtts;
    private INIFileBool m_ComputeDispersion;
    private INIFileDouble m_VarBasedDispNormWeight;
    private INIFileNominalOrDoubleOrVector m_DispersionWeights;
    private INIFileInt m_RandomRules;
    private INIFileBool m_RuleWiseErrors;
    private INIFileBool m_constrainedToFirstAttVal;
    private INIFileInt m_OptDEPopSize;
    private INIFileInt m_OptDENumEval;
    private INIFileDouble m_OptDECrossProb;
    private INIFileDouble m_OptDEWeight;
    private INIFileInt m_OptDESeed;
    private INIFileDouble m_OptDERegulPower;
    private INIFileDouble m_OptDEProbMutationZero;
    private INIFileDouble m_OptDEProbMutationNonZero;
    private INIFileDouble m_OptRegPar;
    private INIFileDouble m_OptNbZeroesPar;
    private INIFileDouble m_OptRuleWeightThreshold;
    protected INIFileBool m_OptRuleWeightBinarization;
    private INIFileEnum<OptimizationLossFunction> m_OptLossFunction;
    private INIFileDouble m_OptHuberAlpha;
    private INIFileBool m_OptDefaultShiftPred;
    private INIFileEnum<OptimizationGDAddLinearTerms> m_OptAddLinearTerms;
    private INIFileEnum<OptimizationLinearTermNormalizeValues> m_OptNormalizeLinearTerms;
    private INIFileBool m_OptLinearTermsTruncate;
    private INIFileBool m_OptOmitRulePredictions;
    private INIFileBool m_OptWeightGenerality;
    private INIFileEnum<OptimizationNormalization> m_OptNormalization;
    private INIFileInt m_OptGDMaxIter;
    private INIFileDouble m_OptGDGradTreshold;
    private INIFileDouble m_OptGDStepSize;
    private INIFileBool m_OptGDIsDynStepsize;
    private INIFileInt m_OptGDMaxNbWeights;
    private INIFileDouble m_OptGDEarlyStopAmount;
    private INIFileDouble m_OptGDEarlyStopTreshold;
    private INIFileStringOrInt m_OptGDNbOfStepSizeReduce;
    private INIFileEnum<GDExternalMethodValues> m_OptGDExternalMethod;
    private INIFileEnum<OptimizationGDMTCombineGradient> m_OptGDMTGradientCombine;
    private INIFileInt m_OptGDNbOfTParameterTry;
    private INIFileBool m_OptGDEarlyTTryStop;
    private INIFileBool m_ROSAddRulesWithTotalAveraging;
    private INIFileBool m_ROSParameterAutoTune;
    private INIFileInt m_MaxRuleCardinality;
    private INIFileInt m_MaxPoissonIterations;
    private INIFileInt m_NumberOfSampledRuleSets;
    private INIFileDouble m_ValidationSetPercentage;
    private boolean m_ruleInduceParamsDisabled = false;
    private double m_origHeurRuleDistPar = 0.0;
    private RulePredictionMethod m_origRulePredictionMethod = RulePredictionMethod.DecisionList;
    private CoveringMethod m_origCoveringMethod = CoveringMethod.Standard;

    public SettingsRules(int position) {
        super(position, "Rules");
    }

    public void setSectionRulesEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public boolean isPrintAllRules() {
        return this.m_PrintAllRules.getValue();
    }

    public void setPrintAllRules(boolean value) {
        this.m_PrintAllRules.setValue(value);
    }

    public INIFileNominalOrDoubleOrVector getDispersionWeights() {
        return this.m_DispersionWeights;
    }

    public boolean isRandomRules() {
        return this.m_RandomRules.getValue() > 0;
    }

    public int nbRandomRules() {
        return this.m_RandomRules.getValue();
    }

    public boolean isRuleWiseErrors() {
        return this.m_RuleWiseErrors.getValue();
    }

    public CoveringMethod getCoveringMethod() {
        return this.m_CoveringMethod.getValue();
    }

    public void setCoveringMethod(CoveringMethod method) {
        this.m_CoveringMethod.setValue(method);
    }

    public RulePredictionMethod getRulePredictionMethod() {
        return this.m_PredictionMethod.getValue();
    }

    public boolean isRulePredictionOptimized() {
        return Arrays.asList(RulePredictionMethod.Optimized, RulePredictionMethod.GDOptimized, RulePredictionMethod.GDOptimizedBinary).contains((Object)this.getRulePredictionMethod());
    }

    public void setRulePredictionMethod(RulePredictionMethod method) {
        this.m_PredictionMethod.setValue(method);
    }

    public RuleAddingMethod getRuleAddingMethod() {
        return this.m_RuleAddingMethod.getValue();
    }

    public void setRuleAddingMethod(RuleAddingMethod method) {
        this.m_RuleAddingMethod.setValue(method);
    }

    public double getCoveringWeight() {
        return this.m_CoveringWeight.getValue();
    }

    public void setCoveringWeight(double weight) {
        this.m_CoveringWeight.setValue(weight);
    }

    public double getInstCoveringWeightThreshold() {
        return this.m_InstCoveringWeightThreshold.getValue();
    }

    public void setInstCoveringWeightThreshold(double thresh) {
        this.m_InstCoveringWeightThreshold.setValue(thresh);
    }

    public InitialRuleGeneratingMethod getInitialRuleGeneratingMethod() {
        return this.m_InitialRuleGeneratingMethod.getValue();
    }

    public void setInitialRuleGeneratingMethod(InitialRuleGeneratingMethod method) {
        this.m_InitialRuleGeneratingMethod.setValue(method);
    }

    public int getMaxRulesNb() {
        return this.m_MaxRulesNb.getValue();
    }

    public void setMaxRulesNb(int nb) {
        this.m_MaxRulesNb.setValue(nb);
    }

    public double getRuleSignificanceLevel() {
        return this.m_RuleSignificanceLevel.getValue();
    }

    public int getRuleNbSigAtt() {
        return this.m_RuleNbSigAtts.getValue();
    }

    public boolean isRuleSignificanceTesting() {
        return this.m_RuleNbSigAtts.getValue() != 0;
    }

    public double getHeurDispOffset() {
        return this.m_HeurDispOffset.getValue();
    }

    public double getHeurCoveragePar() {
        return this.m_HeurCoveragePar.getValue();
    }

    public double getHeurRuleDistPar() {
        return this.m_HeurRuleDistPar.getValue();
    }

    public void setHeurRuleDistPar(double value) {
        this.m_HeurRuleDistPar.setValue(value);
    }

    public boolean isHeurRuleDist() {
        return this.m_HeurRuleDistPar.getValue() > 0.0;
    }

    public boolean isWeightedCovering() {
        return Arrays.asList(CoveringMethod.WeightedAdditive, CoveringMethod.WeightedMultiplicative, CoveringMethod.WeightedError).contains((Object)this.m_CoveringMethod.getValue());
    }

    public double getHeurPrototypeDistPar() {
        return this.m_HeurPrototypeDistPar.getValue();
    }

    public void setHeurPrototypeDistPar(double value) {
        this.m_HeurPrototypeDistPar.setValue(value);
    }

    public boolean isHeurPrototypeDistPar() {
        return this.m_HeurPrototypeDistPar.getValue() > 0.0;
    }

    public boolean getRuleInduceParamsDisabled() {
        return this.m_ruleInduceParamsDisabled;
    }

    public void disableRuleInduceParams() {
        if (!this.m_ruleInduceParamsDisabled) {
            this.m_origHeurRuleDistPar = this.getHeurRuleDistPar();
            this.m_origRulePredictionMethod = this.getRulePredictionMethod();
            this.m_origCoveringMethod = this.getCoveringMethod();
            this.setHeurRuleDistPar(0.0);
            this.setRulePredictionMethod(RulePredictionMethod.DecisionList);
            this.setCoveringMethod(CoveringMethod.RulesFromTree);
            this.m_ruleInduceParamsDisabled = true;
        }
    }

    public void returnRuleInduceParams() {
        if (this.m_ruleInduceParamsDisabled) {
            this.setHeurRuleDistPar(this.m_origHeurRuleDistPar);
            this.setRulePredictionMethod(this.m_origRulePredictionMethod);
            this.setCoveringMethod(this.m_origCoveringMethod);
            this.m_ruleInduceParamsDisabled = false;
        }
    }

    public boolean computeDispersion() {
        return this.m_ComputeDispersion.getValue();
    }

    public double getVarBasedDispNormWeight() {
        return this.m_VarBasedDispNormWeight.getValue();
    }

    public boolean isConstrainedToFirstAttVal() {
        return this.m_constrainedToFirstAttVal.getValue();
    }

    public double getOptDECrossProb() {
        return this.m_OptDECrossProb.getValue();
    }

    public int getOptDENumEval() {
        return this.m_OptDENumEval.getValue();
    }

    public int getOptDEPopSize() {
        return this.m_OptDEPopSize.getValue();
    }

    public int getOptDESeed() {
        return this.m_OptDESeed.getValue();
    }

    public double getOptDEWeight() {
        return this.m_OptDEWeight.getValue();
    }

    public double getOptRegPar() {
        return this.m_OptRegPar.getValue();
    }

    public void setOptRegPar(double newValue) {
        this.m_OptRegPar.setValue(newValue);
    }

    public double getOptNbZeroesPar() {
        return this.m_OptNbZeroesPar.getValue();
    }

    public void setOptNbZeroesPar(double newValue) {
        this.m_OptNbZeroesPar.setValue(newValue);
    }

    public double getOptRuleWeightThreshold() {
        return this.m_OptRuleWeightThreshold.getValue();
    }

    public boolean getOptRuleWeightBinarization() {
        return this.m_OptRuleWeightBinarization.getValue();
    }

    public boolean isOptDefaultShiftPred() {
        return this.m_OptDefaultShiftPred.getValue();
    }

    public boolean isOptAddLinearTerms() {
        return !this.m_OptAddLinearTerms.getValue().equals((Object)OptimizationGDAddLinearTerms.No);
    }

    public OptimizationGDAddLinearTerms getOptAddLinearTerms() {
        return this.m_OptAddLinearTerms.getValue();
    }

    public boolean isOptNormalizeLinearTerms() {
        return !this.m_OptNormalizeLinearTerms.getValue().equals((Object)OptimizationLinearTermNormalizeValues.No);
    }

    public OptimizationLinearTermNormalizeValues getOptNormalizeLinearTerms() {
        return this.m_OptNormalizeLinearTerms.getValue();
    }

    public boolean isOptLinearTermsTruncate() {
        return this.m_OptLinearTermsTruncate.getValue();
    }

    public boolean isOptOmitRulePredictions() {
        return this.m_OptOmitRulePredictions.getValue();
    }

    public boolean isOptWeightGenerality() {
        return this.m_OptWeightGenerality.getValue();
    }

    public boolean isOptNormalization() {
        return !this.m_OptNormalization.getValue().equals((Object)OptimizationNormalization.No);
    }

    public OptimizationNormalization getOptNormalization() {
        return this.m_OptNormalization.getValue();
    }

    public OptimizationLossFunction getOptDELossFunction() {
        return this.m_OptLossFunction.getValue();
    }

    public double getOptDERegulPower() {
        return this.m_OptDERegulPower.getValue();
    }

    public double getOptDEProbMutationZero() {
        return this.m_OptDEProbMutationZero.getValue();
    }

    public double getOptDEProbMutationNonZero() {
        return this.m_OptDEProbMutationNonZero.getValue();
    }

    public double getOptHuberAlpha() {
        return this.m_OptHuberAlpha.getValue();
    }

    public int getOptGDMaxIter() {
        return this.m_OptGDMaxIter.getValue();
    }

    public void setOptGDMaxIter(int value) {
        this.m_OptGDMaxIter.setValue(value);
    }

    public OptimizationLossFunction getOptGDLossFunction() {
        return this.m_OptLossFunction.getValue();
    }

    public double getOptGDGradTreshold() {
        return this.m_OptGDGradTreshold.getValue();
    }

    public void setOptGDGradTreshold(double newVal) {
        this.m_OptGDGradTreshold.setValue(newVal);
    }

    public double getOptGDStepSize() {
        return this.m_OptGDStepSize.getValue();
    }

    public boolean isOptGDIsDynStepsize() {
        return this.m_OptGDIsDynStepsize.getValue();
    }

    public double getOptGDEarlyStopAmount() {
        return this.m_OptGDEarlyStopAmount.getValue();
    }

    public double getOptGDEarlyStopTreshold() {
        return this.m_OptGDEarlyStopTreshold.getValue();
    }

    public int getOptGDMaxNbWeights() {
        return this.m_OptGDMaxNbWeights.getValue();
    }

    public void setOptGDMaxNbWeights(int nbWeights) {
        this.m_OptGDMaxNbWeights.setValue(nbWeights);
    }

    public int getOptGDNbOfStepSizeReduce() {
        if (this.m_OptGDNbOfStepSizeReduce.isString("Infinity")) {
            return Integer.MAX_VALUE;
        }
        return this.m_OptGDNbOfStepSizeReduce.getIntValue();
    }

    public GDExternalMethodValues getOptGDExternalMethod() {
        return this.m_OptGDExternalMethod.getValue();
    }

    public OptimizationGDMTCombineGradient getOptGDMTGradientCombine() {
        return this.m_OptGDMTGradientCombine.getValue();
    }

    public int getOptGDNbOfTParameterTry() {
        return this.m_OptGDNbOfTParameterTry.getValue();
    }

    public boolean getOptGDEarlyTTryStop() {
        return this.m_OptGDEarlyTTryStop.getValue();
    }

    public int getMaxRuleCardinality() {
        return this.m_MaxRuleCardinality.getValue();
    }

    public int getMaxPoissonIterations() {
        return this.m_MaxPoissonIterations.getValue();
    }

    public int getNumberOfSampledRuleSets() {
        return this.m_NumberOfSampledRuleSets.getValue();
    }

    public Double getValidationSetPercentage() {
        return this.m_ValidationSetPercentage.getValue();
    }

    public void setIS_RULE_SIG_TESTING(boolean value) {
        this.IS_RULE_SIG_TESTING = value;
    }

    public boolean getIS_RULE_SIG_TESTING() {
        return this.IS_RULE_SIG_TESTING;
    }

    public boolean getROSAddRulesWithTotalAveraging() {
        return this.m_ROSAddRulesWithTotalAveraging.getValue();
    }

    public boolean isROSParameterAutoTune() {
        return this.m_ROSParameterAutoTune.getValue();
    }

    @Override
    public void create() {
        this.m_CoveringMethod = new INIFileEnum<CoveringMethod>("CoveringMethod", CoveringMethod.Standard);
        this.m_Section.addNode(this.m_CoveringMethod);
        this.m_PredictionMethod = new INIFileEnum<RulePredictionMethod>("PredictionMethod", RulePredictionMethod.DecisionList);
        this.m_Section.addNode(this.m_PredictionMethod);
        this.m_RuleAddingMethod = new INIFileEnum<RuleAddingMethod>("RuleAddingMethod", RuleAddingMethod.Always);
        this.m_Section.addNode(this.m_RuleAddingMethod);
        this.m_CoveringWeight = new INIFileDouble("CoveringWeight", 0.1);
        this.m_Section.addNode(this.m_CoveringWeight);
        this.m_InstCoveringWeightThreshold = new INIFileDouble("InstCoveringWeightThreshold", 0.1);
        this.m_Section.addNode(this.m_InstCoveringWeightThreshold);
        this.m_MaxRulesNb = new INIFileInt("MaxRulesNb", 1000);
        this.m_Section.addNode(this.m_MaxRulesNb);
        this.m_HeurDispOffset = new INIFileDouble("HeurDispOffset", 0.0);
        this.m_Section.addNode(this.m_HeurDispOffset);
        this.m_HeurCoveragePar = new INIFileDouble("HeurCoveragePar", 1.0);
        this.m_Section.addNode(this.m_HeurCoveragePar);
        this.m_HeurRuleDistPar = new INIFileDouble("HeurRuleDistPar", 0.0);
        this.m_Section.addNode(this.m_HeurRuleDistPar);
        this.m_HeurPrototypeDistPar = new INIFileDouble("HeurPrototypeDistPar", 0.0);
        this.m_Section.addNode(this.m_HeurPrototypeDistPar);
        this.m_InitialRuleGeneratingMethod = new INIFileEnum<InitialRuleGeneratingMethod>("InitialRuleGeneratingMethod", InitialRuleGeneratingMethod.RandomForest);
        this.m_Section.addNode(this.m_InitialRuleGeneratingMethod);
        this.m_RuleSignificanceLevel = new INIFileDouble("RuleSignificanceLevel", 0.05);
        this.m_Section.addNode(this.m_RuleSignificanceLevel);
        this.m_RuleNbSigAtts = new INIFileInt("RuleNbSigAtts", 0);
        this.m_Section.addNode(this.m_RuleNbSigAtts);
        this.m_ComputeDispersion = new INIFileBool("ComputeDispersion", false);
        this.m_Section.addNode(this.m_ComputeDispersion);
        this.m_VarBasedDispNormWeight = new INIFileDouble("VarBasedDispNormWeight", 4.0);
        this.m_Section.addNode(this.m_VarBasedDispNormWeight);
        this.m_DispersionWeights = new INIFileNominalOrDoubleOrVector("DispersionWeights", EMPTY);
        this.m_Section.addNode(this.m_DispersionWeights);
        this.m_DispersionWeights.setArrayIndexNames(SettingsAttribute.NUM_NOM_TAR_NTAR_WEIGHTS);
        this.m_DispersionWeights.setDoubleArray(FOUR_ONES);
        this.m_DispersionWeights.setArrayIndexNames(true);
        this.m_RandomRules = new INIFileInt("RandomRules", 0);
        this.m_Section.addNode(this.m_RandomRules);
        this.m_RuleWiseErrors = new INIFileBool("PrintRuleWiseErrors", false);
        this.m_Section.addNode(this.m_RuleWiseErrors);
        this.m_PrintAllRules = new INIFileBool("PrintAllRules", true);
        this.m_Section.addNode(this.m_PrintAllRules);
        this.m_constrainedToFirstAttVal = new INIFileBool("ConstrainedToFirstAttVal", false);
        this.m_Section.addNode(this.m_constrainedToFirstAttVal);
        this.m_OptDEPopSize = new INIFileInt("OptDEPopSize", 500);
        this.m_Section.addNode(this.m_OptDEPopSize);
        this.m_OptDENumEval = new INIFileInt("OptDENumEval", 10000);
        this.m_Section.addNode(this.m_OptDENumEval);
        this.m_OptDECrossProb = new INIFileDouble("OptDECrossProb", 0.3);
        this.m_Section.addNode(this.m_OptDECrossProb);
        this.m_OptDEWeight = new INIFileDouble("OptDEWeight", 0.5);
        this.m_Section.addNode(this.m_OptDEWeight);
        this.m_OptDESeed = new INIFileInt("OptDESeed", 0);
        this.m_Section.addNode(this.m_OptDESeed);
        this.m_OptDERegulPower = new INIFileDouble("OptDERegulPower", 1.0);
        this.m_Section.addNode(this.m_OptDERegulPower);
        this.m_OptDEProbMutationZero = new INIFileDouble("OptDEProbMutationZero", 0.0);
        this.m_Section.addNode(this.m_OptDEProbMutationZero);
        this.m_OptDEProbMutationNonZero = new INIFileDouble("OptDEProbMutationNonZero", 0.0);
        this.m_Section.addNode(this.m_OptDEProbMutationNonZero);
        this.m_OptRegPar = new INIFileDouble("OptRegPar", 0.0);
        this.m_Section.addNode(this.m_OptRegPar);
        this.m_OptNbZeroesPar = new INIFileDouble("OptNbZeroesPar", 0.0);
        this.m_Section.addNode(this.m_OptNbZeroesPar);
        this.m_OptRuleWeightThreshold = new INIFileDouble("OptRuleWeightThreshold", 0.1);
        this.m_Section.addNode(this.m_OptRuleWeightThreshold);
        this.m_OptRuleWeightBinarization = new INIFileBool("OptRuleWeightBinarization", false);
        this.m_Section.addNode(this.m_OptRuleWeightBinarization);
        this.m_OptLossFunction = new INIFileEnum<OptimizationLossFunction>("OptDELossFunction", OptimizationLossFunction.Squared);
        this.m_Section.addNode(this.m_OptLossFunction);
        this.m_OptDefaultShiftPred = new INIFileBool("OptDefaultShiftPred", true);
        this.m_Section.addNode(this.m_OptDefaultShiftPred);
        this.m_OptAddLinearTerms = new INIFileEnum<OptimizationGDAddLinearTerms>("OptAddLinearTerms", OptimizationGDAddLinearTerms.No);
        this.m_Section.addNode(this.m_OptAddLinearTerms);
        this.m_OptNormalizeLinearTerms = new INIFileEnum<OptimizationLinearTermNormalizeValues>("OptNormalizeLinearTerms", OptimizationLinearTermNormalizeValues.Yes);
        this.m_Section.addNode(this.m_OptNormalizeLinearTerms);
        this.m_OptLinearTermsTruncate = new INIFileBool("OptLinearTermsTruncate", true);
        this.m_Section.addNode(this.m_OptLinearTermsTruncate);
        this.m_OptOmitRulePredictions = new INIFileBool("OptOmitRulePredictions", true);
        this.m_Section.addNode(this.m_OptOmitRulePredictions);
        this.m_OptWeightGenerality = new INIFileBool("OptWeightGenerality", false);
        this.m_Section.addNode(this.m_OptWeightGenerality);
        this.m_OptNormalization = new INIFileEnum<OptimizationNormalization>("OptNormalization", OptimizationNormalization.Yes);
        this.m_Section.addNode(this.m_OptNormalization);
        this.m_OptHuberAlpha = new INIFileDouble("OptHuberAlpha", 0.9);
        this.m_Section.addNode(this.m_OptHuberAlpha);
        this.m_OptGDMaxIter = new INIFileInt("OptGDMaxIter", 1000);
        this.m_Section.addNode(this.m_OptGDMaxIter);
        this.m_OptGDGradTreshold = new INIFileDouble("OptGDGradTreshold", 1.0);
        this.m_Section.addNode(this.m_OptGDGradTreshold);
        this.m_OptGDStepSize = new INIFileDouble("OptGDStepSize", 0.1);
        this.m_Section.addNode(this.m_OptGDStepSize);
        this.m_OptGDIsDynStepsize = new INIFileBool("OptGDIsDynStepsize", true);
        this.m_Section.addNode(this.m_OptGDIsDynStepsize);
        this.m_OptGDMaxNbWeights = new INIFileInt("OptGDMaxNbWeights", 0);
        this.m_Section.addNode(this.m_OptGDMaxNbWeights);
        this.m_OptGDEarlyStopAmount = new INIFileDouble("OptGDEarlyStopAmount", 0.0);
        this.m_Section.addNode(this.m_OptGDEarlyStopAmount);
        this.m_OptGDEarlyStopTreshold = new INIFileDouble("OptGDEarlyStopTreshold", 1.1);
        this.m_Section.addNode(this.m_OptGDEarlyStopTreshold);
        this.m_OptGDNbOfStepSizeReduce = new INIFileStringOrInt("OptGDNbOfStepSizeReduce", "Infinity");
        this.m_Section.addNode(this.m_OptGDNbOfStepSizeReduce);
        this.m_OptGDExternalMethod = new INIFileEnum<GDExternalMethodValues>("OptGDExternalMethod", GDExternalMethodValues.Update);
        this.m_Section.addNode(this.m_OptGDExternalMethod);
        this.m_OptGDMTGradientCombine = new INIFileEnum<OptimizationGDMTCombineGradient>("OptGDMTGradientCombine", OptimizationGDMTCombineGradient.Avg);
        this.m_Section.addNode(this.m_OptGDMTGradientCombine);
        this.m_OptGDNbOfTParameterTry = new INIFileInt("OptGDNbOfTParameterTry", 1);
        this.m_Section.addNode(this.m_OptGDNbOfTParameterTry);
        this.m_OptGDEarlyTTryStop = new INIFileBool("OptGDEarlyTTryStop", true);
        this.m_Section.addNode(this.m_OptGDEarlyTTryStop);
        this.m_ROSAddRulesWithTotalAveraging = new INIFileBool("ROSAddRulesWithTotalAveraging", true);
        this.m_Section.addNode(this.m_ROSAddRulesWithTotalAveraging);
        this.m_ROSParameterAutoTune = new INIFileBool("ROSParameterAutoTune", false);
        this.m_Section.addNode(this.m_ROSParameterAutoTune);
        this.m_MaxRuleCardinality = new INIFileInt("MaxRuleCardinality", 30);
        this.m_Section.addNode(this.m_MaxRuleCardinality);
        this.m_MaxPoissonIterations = new INIFileInt("MaxPoissonIterations", 1000);
        this.m_Section.addNode(this.m_MaxPoissonIterations);
        this.m_NumberOfSampledRuleSets = new INIFileInt("NumberOfSampledRuleSets", 100);
        this.m_Section.addNode(this.m_NumberOfSampledRuleSets);
        this.m_ValidationSetPercentage = new INIFileDouble("ValidationSetPercentage", 0.33);
        this.m_Section.addNode(this.m_ValidationSetPercentage);
        this.m_Section.setEnabled(false);
    }

    public static enum RulePredictionMethod {
        DecisionList,
        TotCoverageWeighted,
        CoverageWeighted,
        AccuracyWeighted,
        AccCovWeighted,
        EquallyWeighted,
        Optimized,
        Union,
        GDOptimized,
        GDOptimizedBinary;

    }

    public static enum CoveringMethod {
        Standard,
        WeightedMultiplicative,
        WeightedAdditive,
        WeightedError,
        Union,
        BeamRuleDefSet,
        RandomRuleSet,
        StandardBootstrap,
        HeurOnly,
        RulesFromTree,
        SampledRuleSet;

    }

    public static enum RuleAddingMethod {
        Always,
        IfBetter,
        IfBetterBeam;

    }

    public static enum InitialRuleGeneratingMethod {
        RandomForest("Random forest"),
        OptionTree("Option tree");

        private String name = "";

        private InitialRuleGeneratingMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum OptimizationGDAddLinearTerms {
        No,
        Yes,
        YesSaveMemory;

    }

    public static enum OptimizationLinearTermNormalizeValues {
        No,
        Yes,
        YesAndConvert;

    }

    public static enum OptimizationNormalization {
        No,
        Yes,
        OnlyScaling,
        YesVariance;

    }

    public static enum OptimizationLossFunction {
        Squared,
        ZeroOneError,
        RRMSE,
        Huber;

    }

    public static enum GDExternalMethodValues {
        Update,
        Brute;

    }

    public static enum OptimizationGDMTCombineGradient {
        Avg,
        Max,
        MaxLoss,
        MaxLossFast;

    }
}

