/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrIntOrVector;

public class SettingsRelief
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    public static final int RELIEF_NEIGHBOUR_DEFAULT = 10;
    public static final int RELIEF_ITERATIONS_DEFAULT = -1;
    private INIFileNominalOrIntOrVector m_ReliefNbNeighbours;
    private INIFileNominalOrDoubleOrVector m_ReliefNbIterations;
    private INIFileBool m_ReliefShouldHaveNeighbourWeighting;
    private INIFileDouble m_ReliefWeightingSigma;
    private INIFileNominalOrIntOrVector m_ChosenInstances;
    private INIFileBool m_ReliefIndicesInRankingNames;
    public static int[] DUMMY_INSTANCES = new int[]{-1};
    private INIFileEnum<MultilabelDistance> m_MultilabelDistance;
    private INIFileEnum<ReliefStatisticsType> mReliefStatistics;
    private INIFileEnum<MissingTargetHandling> m_MissingTargetHandling;

    public SettingsRelief(int position) {
        super(position, "Relief");
    }

    public void setSectionReliefEnabled(boolean value) {
        this.m_Section.setEnabled(value);
    }

    public boolean isRelief() {
        return this.m_Section.isEnabled();
    }

    public int[] getReliefNbNeighboursValue() {
        return this.m_ReliefNbNeighbours.getIntVector();
    }

    public boolean shouldUseIndicesInNames() {
        return this.m_ReliefIndicesInRankingNames.getValue();
    }

    public int[] getReliefNbIterationsValue(int nbInstances) {
        int i;
        double[] values = this.m_ReliefNbIterations.isVector() ? this.m_ReliefNbIterations.getDoubleVector() : new double[]{this.m_ReliefNbIterations.getDouble()};
        boolean[] types = new boolean[]{true, true};
        boolean containsOne = false;
        for (double value : values) {
            if (Math.abs(1.0 - value) >= 1.0E-9) {
                int roundedValue = (int)Math.round(value);
                int wrong_type = Math.abs((double)roundedValue - value) >= 1.0E-9 ? 1 : 0;
                types[wrong_type] = false;
                continue;
            }
            containsOne = true;
        }
        int[] iterations = new int[values.length];
        if (values.length == 1 && containsOne) {
            System.err.print(String.format("Warning! Ambiguous setting: %s = 1.0", this.m_ReliefNbIterations.getName()));
            System.err.println(" Assuming 1.0 means 100%.");
        }
        if (!types[0] && !types[1]) {
            throw new RuntimeException(String.format("The values for the setting %s must be of the same type!", this.m_ReliefNbIterations.getName()));
        }
        if (types[0]) {
            for (i = 0; i < values.length; ++i) {
                double value = values[i];
                if (!(0.0 <= value) || !(value <= 1.0)) {
                    throw new RuntimeException("The value is not in the interval [0, 1]!");
                }
                iterations[i] = (int)Math.round(value * (double)nbInstances);
            }
        } else {
            for (i = 0; i < values.length; ++i) {
                iterations[i] = (int)Math.round(values[i]);
            }
        }
        return iterations;
    }

    public boolean getReliefWeightNeighbours() {
        return this.m_ReliefShouldHaveNeighbourWeighting.getValue();
    }

    public double getReliefWeightingSigma() {
        return this.m_ReliefWeightingSigma.getValue();
    }

    public int[] getChosenIntances() {
        return this.m_ChosenInstances.getIntVector();
    }

    public MultilabelDistance getMultilabelDistance() {
        return this.m_MultilabelDistance.getValue();
    }

    public ReliefStatisticsType getReliefStatisticsType() {
        return this.mReliefStatistics.getValue();
    }

    public MissingTargetHandling getMissingTargetHandling() {
        return this.m_MissingTargetHandling.getValue();
    }

    @Override
    public void create() {
        this.m_ReliefNbNeighbours = new INIFileNominalOrIntOrVector("Neighbours", NONELIST);
        this.m_Section.addNode(this.m_ReliefNbNeighbours);
        this.m_ReliefNbNeighbours.setInt(10);
        this.m_ReliefNbIterations = new INIFileNominalOrDoubleOrVector("Iterations", NONELIST);
        this.m_Section.addNode(this.m_ReliefNbIterations);
        this.m_ReliefNbIterations.setDouble(-1.0);
        this.m_ReliefShouldHaveNeighbourWeighting = new INIFileBool("WeightNeighbours", false);
        this.m_Section.addNode(this.m_ReliefShouldHaveNeighbourWeighting);
        this.m_ReliefWeightingSigma = new INIFileDouble("WeightingSigma", 0.5);
        this.m_Section.addNode(this.m_ReliefWeightingSigma);
        this.m_ChosenInstances = new INIFileNominalOrIntOrVector("ChosenInstances", NONELIST);
        this.m_Section.addNode(this.m_ChosenInstances);
        this.m_ChosenInstances.setIntVector(DUMMY_INSTANCES);
        this.m_MultilabelDistance = new INIFileEnum<MultilabelDistance>("MultilabelDistance", MultilabelDistance.HammingLoss);
        this.m_Section.addNode(this.m_MultilabelDistance);
        this.mReliefStatistics = new INIFileEnum<ReliefStatisticsType>("ReliefStatisticsType", ReliefStatisticsType.DistanceClassic);
        this.m_Section.addNode(this.mReliefStatistics);
        this.m_ReliefIndicesInRankingNames = new INIFileBool("UseIndicesInRankingNames", false);
        this.m_Section.addNode(this.m_ReliefIndicesInRankingNames);
        this.m_MissingTargetHandling = new INIFileEnum<MissingTargetHandling>("MissingTargetHandling", MissingTargetHandling.Impute);
        this.m_Section.addNode(this.m_MissingTargetHandling);
        this.m_Section.setEnabled(false);
    }

    public static enum MultilabelDistance {
        HammingLoss,
        MLAccuracy,
        MLFOne,
        SubsetAccuracy;

    }

    public static enum ReliefStatisticsType {
        DistanceClassic,
        Variance,
        DistanceSimplified,
        Steepness;

    }

    public static enum MissingTargetHandling {
        Impute,
        UseDescriptive;

    }
}

