/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.range.DoubleRangeCheck;
import si.ijs.kt.clus.util.jeans.io.range.IntRangeCheck;

public class SettingsOptionTree
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    protected INIFileDouble m_optionFactor;
    protected INIFileDouble m_optionDecayFactor;
    protected INIFileDouble m_optionEpsilon;
    protected INIFileInt m_optionMaxNumberOfOptionsPerNode;
    protected INIFileInt m_optionMaxDepthOfOptionNode;

    public SettingsOptionTree(int position) {
        super(position, "OptionTree");
    }

    public boolean isSectionOptionEnabled() {
        return this.m_Section.isEnabled();
    }

    public double getOptionDecayFactor() {
        return this.m_optionDecayFactor.getValue();
    }

    public double getOptionEpsilon() {
        return this.m_optionEpsilon.getValue();
    }

    public int getOptionMaxNumberOfOptionsPerNode() {
        return this.m_optionMaxNumberOfOptionsPerNode.getValue();
    }

    public int getOptionMaxDepthOfOptionNode() {
        return this.m_optionMaxDepthOfOptionNode.getValue();
    }

    public void setSectionOptionEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    @Override
    public void create() {
        this.m_optionDecayFactor = new INIFileDouble("DecayFactor", 0.9);
        this.m_Section.addNode(this.m_optionDecayFactor);
        this.m_optionDecayFactor.setValueCheck(new DoubleRangeCheck(0.0, 1.0));
        this.m_optionEpsilon = new INIFileDouble("Epsilon", 0.1);
        this.m_Section.addNode(this.m_optionEpsilon);
        this.m_optionEpsilon.setValueCheck(new DoubleRangeCheck(0.0, 1.0));
        this.m_optionMaxNumberOfOptionsPerNode = new INIFileInt("MaxNumberOfOptionsPerNode", 5);
        this.m_Section.addNode(this.m_optionMaxNumberOfOptionsPerNode);
        this.m_optionMaxNumberOfOptionsPerNode.setValueCheck(new IntRangeCheck(2, Integer.MAX_VALUE));
        this.m_optionMaxDepthOfOptionNode = new INIFileInt("MaxDepthOfOptionNode", 3);
        this.m_Section.addNode(this.m_optionMaxDepthOfOptionNode);
        this.m_optionMaxDepthOfOptionNode.setValueCheck(new IntRangeCheck(1, Integer.MAX_VALUE));
        this.m_Section.setEnabled(false);
    }
}

