/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.Arrays;
import java.util.List;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.main.settings.section.SettingsRelief;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnumList;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileSection;

public class SettingsMLC
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    SettingsHMLC m_SettHMLC;
    SettingsRelief m_SettRelief;
    protected INIFileNominalOrDoubleOrVector m_MultiLabelThreshold;
    protected INIFileEnum<MultiLabelThresholdOptimization> m_MultiLabelOptimizeThreshold;
    protected INIFileEnumList<MultiLabelMeasures> m_MultiLabelRankingMeasure;
    protected INIFileBool m_ShowThresholds;

    public SettingsMLC(int position, SettingsHMLC settHMLC, SettingsRelief settRelief) {
        super(position, "Multilabel");
        this.m_SettHMLC = settHMLC;
        this.m_SettRelief = settRelief;
    }

    public void setSectionMultiLabelEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public INIFileSection getSectionMultiLabel() {
        return this.m_Section;
    }

    public INIFileNominalOrDoubleOrVector getMultiLabelThreshold() {
        return this.m_MultiLabelThreshold;
    }

    public List<MultiLabelMeasures> getMultiLabelRankingMeasures() {
        return this.m_MultiLabelRankingMeasure.getValue();
    }

    public void setToAllMultiLabelRankingMeasures() {
        List<MultiLabelMeasures> vals = Arrays.asList(MultiLabelMeasures.values());
        this.m_MultiLabelRankingMeasure.setValue(vals);
    }

    public MultiLabelThresholdOptimization getMultiLabelThresholdOptimization() {
        return this.m_MultiLabelOptimizeThreshold.getValue();
    }

    public boolean shouldRunThresholdOptimization() {
        if (this.getSectionMultiLabel().isEnabled() || this.m_SettHMLC.isSectionHierarchicalEnabled()) {
            return this.getMultiLabelThresholdOptimization().equals((Object)MultiLabelThresholdOptimization.Yes);
        }
        return false;
    }

    public boolean shouldShowThresholds() {
        if (!this.m_ShowThresholds.getValue()) {
            return false;
        }
        if (this.m_SettRelief.isRelief()) {
            return false;
        }
        if (this.shouldRunThresholdOptimization()) {
            return true;
        }
        return this.m_Section.isEnabled();
    }

    public boolean shouldShowThresholds(String modelName) {
        if (modelName.equals("Default") || modelName.equals("Original") || modelName.equals("Pruned")) {
            return true;
        }
        return modelName.startsWith("Forest with ") && !modelName.contains("trees(T = ");
    }

    @Override
    public void create() {
        this.m_MultiLabelThreshold = new INIFileNominalOrDoubleOrVector("MLCThreshold", NONELIST);
        this.m_Section.addNode(this.m_MultiLabelThreshold);
        this.m_MultiLabelThreshold.setDouble(0.5);
        this.m_MultiLabelOptimizeThreshold = new INIFileEnum<MultiLabelThresholdOptimization>("OptimizeThresholds", MultiLabelThresholdOptimization.No);
        this.m_Section.addNode(this.m_MultiLabelOptimizeThreshold);
        this.m_MultiLabelRankingMeasure = new INIFileEnumList<MultiLabelMeasures>("MultiLabelRankingMeasure", MultiLabelMeasures.HammingLoss);
        this.m_Section.addNode(this.m_MultiLabelRankingMeasure);
        this.m_ShowThresholds = new INIFileBool("ShowThresholds", true);
        this.m_Section.addNode(this.m_ShowThresholds);
    }

    public static enum MultiLabelMeasures {
        HammingLoss,
        MLAccuracy,
        MLPrecision,
        MLRecall,
        MLFOne,
        SubsetAccuracy,
        MacroPrecision,
        MacroRecall,
        MacroFOne,
        MicroPrecision,
        MicroRecall,
        MicroFOne,
        OneError,
        Coverage,
        RankingLoss,
        AveragePrecision,
        AverageAUROC,
        AverageAUPRC,
        WeightedAverageAUPRC,
        PooledAUPRC,
        All;

    }

    public static enum MultiLabelThresholdOptimization {
        Yes,
        No;

    }
}

