/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.Arrays;
import java.util.List;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileArray;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnumList;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrIntOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;

public class SettingsKNN
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileEnum<Distance> m_Distance;
    private INIFileNominalOrIntOrVector m_k;
    private INIFileEnum<SearchMethod> m_SearchMethod;
    private INIFileEnumList<DistanceWeights> m_distanceWeight;
    private INIFileString m_attributeWeight;
    private INIFileNominalOrIntOrVector m_ChosenInstancesTrain;
    private INIFileNominalOrIntOrVector m_ChosenInstancesTest;
    public static int[] DUMMY_INSTANCES = new int[]{-1};
    private INIFileArray m_LoadNeighboursFiles;
    private INIFileString m_SaveNeighboursFile;
    private static String EMPTY_STRING = "";
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private INIFileBool m_IsMlcKnn;
    private INIFileDouble m_MlcCountSmoother;
    private static final int[] DEFAULT_K = new int[]{1, 3};

    public SettingsKNN(int position) {
        super(position, "kNN");
    }

    public int[] getKNNk() {
        return this.m_k.getIntVector();
    }

    public Distance getDistance() {
        return this.m_Distance.getValue();
    }

    public List<DistanceWeights> getKNNDistanceWeights() {
        return this.m_distanceWeight.getValue();
    }

    public String getKNNDistanceWeightsString() {
        return this.m_distanceWeight.getStringValue();
    }

    public String getKNNAttrWeight() {
        return this.m_attributeWeight.getValue();
    }

    public void setKNNAttrWeight(String val) {
        this.m_attributeWeight.setValue(val);
    }

    public void setSectionKNNEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public boolean isKNN() {
        return this.m_Section.isEnabled();
    }

    public SearchMethod getSearchMethod() {
        return this.m_SearchMethod.getValue();
    }

    public int[] getChosenIntancesTrain(int nbTrainInstances) {
        int[] inSettings = this.m_ChosenInstancesTrain.getIntVector();
        return SettingsKNN.getChosenInstances(nbTrainInstances, inSettings);
    }

    public void setChosenIntancesTrain(int[] trainInstances) {
        this.m_ChosenInstancesTrain.setIntVector(trainInstances);
    }

    public int[] getChosenIntancesTest(int nbTestInstances) {
        int[] inSettings = this.m_ChosenInstancesTest.getIntVector();
        return SettingsKNN.getChosenInstances(nbTestInstances, inSettings);
    }

    public boolean shouldSaveNeighbours() {
        return !this.m_SaveNeighboursFile.getValue().equals(EMPTY_STRING);
    }

    public boolean shouldLoadNeighbours() {
        return this.m_LoadNeighboursFiles.getSize() > 0;
    }

    public String[] getLoadNeighboursFiles() {
        String[] files = new String[this.m_LoadNeighboursFiles.getSize()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.m_LoadNeighboursFiles.getStringAt(i);
        }
        return files;
    }

    public String getSaveNeighboursFile() {
        return this.m_SaveNeighboursFile.getValue();
    }

    public boolean mustNotComputeTrainingError(int nbTrainInstances) {
        return SettingsKNN.mustNotComputeError(nbTrainInstances, this.getChosenIntancesTrain(nbTrainInstances));
    }

    public boolean mustNotComputeTestError(int nbTestInstances) {
        return SettingsKNN.mustNotComputeError(nbTestInstances, this.getChosenIntancesTest(nbTestInstances));
    }

    public boolean isMlcKnn() {
        return this.m_IsMlcKnn.getValue();
    }

    private static boolean mustNotComputeError(int nb_instances, int[] chosenInstances) {
        Arrays.sort(chosenInstances);
        int[] range = SettingsKNN.rangeInterval(nb_instances);
        return !Arrays.equals(chosenInstances, range);
    }

    private static int[] getChosenInstances(int nbInstances, int[] chosenInstances) {
        Arrays.sort(chosenInstances);
        if (Arrays.equals(chosenInstances, DUMMY_INSTANCES)) {
            return SettingsKNN.rangeInterval(nbInstances);
        }
        return chosenInstances;
    }

    private static int[] rangeInterval(int upperBound) {
        int[] interval = new int[upperBound];
        for (int i = 0; i < upperBound; ++i) {
            interval[i] = i;
        }
        return interval;
    }

    public double getMlcCountSmoother() {
        return this.m_MlcCountSmoother.getValue();
    }

    @Override
    public void create() {
        this.m_k = new INIFileNominalOrIntOrVector("K", NONELIST);
        this.m_Section.addNode(this.m_k);
        this.m_k.setIntVector(DEFAULT_K);
        this.m_Distance = new INIFileEnum<Distance>("Distance", Distance.Euclidean);
        this.m_Section.addNode(this.m_Distance);
        this.m_SearchMethod = new INIFileEnum<SearchMethod>("SearchMethod", SearchMethod.BruteForce);
        this.m_Section.addNode(this.m_SearchMethod);
        this.m_distanceWeight = new INIFileEnumList<DistanceWeights>("DistanceWeighting", DistanceWeights.Constant);
        this.m_Section.addNode(this.m_distanceWeight);
        this.m_attributeWeight = new INIFileString("AttributeWeighting", "none");
        this.m_Section.addNode(this.m_attributeWeight);
        this.m_ChosenInstancesTrain = new INIFileNominalOrIntOrVector("ChosenInstancesTrain", NONELIST);
        this.m_Section.addNode(this.m_ChosenInstancesTrain);
        this.m_ChosenInstancesTrain.setIntVector(DUMMY_INSTANCES);
        this.m_ChosenInstancesTest = new INIFileNominalOrIntOrVector("ChosenInstancesTest", NONELIST);
        this.m_Section.addNode(this.m_ChosenInstancesTest);
        this.m_ChosenInstancesTest.setIntVector(DUMMY_INSTANCES);
        this.m_LoadNeighboursFiles = new INIFileArray("LoadNeighboursFiles", EMPTY_STRING_ARRAY);
        this.m_Section.addNode(this.m_LoadNeighboursFiles);
        this.m_SaveNeighboursFile = new INIFileString("SaveNeighboursFile", EMPTY_STRING);
        this.m_Section.addNode(this.m_SaveNeighboursFile);
        this.m_IsMlcKnn = new INIFileBool("IsMlcKnn", false);
        this.m_Section.addNode(this.m_IsMlcKnn);
        this.m_MlcCountSmoother = new INIFileDouble("MlcCountSmoother", 1.0);
        this.m_Section.addNode(this.m_MlcCountSmoother);
        this.m_Section.setEnabled(false);
    }

    @Override
    public void initNamedValues() {
    }

    public static enum Distance {
        Euclidean,
        Chebyshev,
        Manhattan;

    }

    public static enum SearchMethod {
        BruteForce,
        VPTree,
        KDTree,
        Oracle;

    }

    public static enum DistanceWeights {
        Constant,
        OneOverD,
        OneMinusD;

    }
}

