/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRNode;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsAttribute;
import si.ijs.kt.clus.main.settings.section.SettingsGeneral;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;

public class SettingsHMTR
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    SettingsAttribute m_SettAttribute;
    SettingsGeneral m_SettGeneral;
    public static final String HMTR_ERROR_POSTFIX = "HMTR";
    protected static INIFileEnum<HierarchyTypesHMTR> m_HMTRType;
    private INIFileEnum<HierarchyDistanceHMTR> m_HMTRDistance;
    private INIFileEnum<HierarchyAggregationsHMTR> m_HMTRAggregation;
    private INIFileString m_HMTRHierarchyString;
    private INIFileDouble m_HMTRHierarchyWeight;
    private boolean m_HMTRUsingDump = false;

    public SettingsHMTR(int position, SettingsAttribute settAttribute, SettingsGeneral settGeneral) {
        super(position, HMTR_ERROR_POSTFIX);
        this.m_SettAttribute = settAttribute;
        this.m_SettGeneral = settGeneral;
    }

    public void setHMTRUsingDump(boolean val) {
        this.m_HMTRUsingDump = val;
    }

    public boolean isHMTRUsingDump() {
        return this.m_HMTRUsingDump;
    }

    public INIFileDouble getHMTRHierarchyWeight() {
        return this.m_HMTRHierarchyWeight;
    }

    public void setSectionHMTREnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public boolean isSectionHMTREnabled() {
        return this.m_Section.isEnabled();
    }

    public boolean isHMTREnabled() {
        return !this.getHMTRType().equals((Object)HierarchyTypesHMTR.Disabled);
    }

    public HierarchyTypesHMTR getHMTRType() {
        return m_HMTRType.getValue();
    }

    public INIFileEnum<HierarchyDistanceHMTR> getHMTRDistance() {
        return this.m_HMTRDistance;
    }

    public HierarchyAggregationsHMTR getHMTRAggregation() {
        return this.m_HMTRAggregation.getValue();
    }

    public String getHMTRAggregationName() {
        return this.m_HMTRAggregation.getStringValue();
    }

    public String getHMTRHierarchyString() {
        return this.m_HMTRHierarchyString.getStringValue();
    }

    @Override
    public void create() {
        m_HMTRType = new INIFileEnum<HierarchyTypesHMTR>("Type", HierarchyTypesHMTR.Disabled);
        this.m_Section.addNode(m_HMTRType);
        this.m_HMTRDistance = new INIFileEnum<HierarchyDistanceHMTR>("Distance", HierarchyDistanceHMTR.WeightedEuclidean);
        this.m_Section.addNode(this.m_HMTRDistance);
        this.m_HMTRAggregation = new INIFileEnum<HierarchyAggregationsHMTR>("Aggregation", HierarchyAggregationsHMTR.SUM);
        this.m_Section.addNode(this.m_HMTRAggregation);
        this.m_HMTRHierarchyString = new INIFileString("Hierarchy");
        this.m_Section.addNode(this.m_HMTRHierarchyString);
        this.m_HMTRHierarchyWeight = new INIFileDouble("Weight");
        this.m_Section.addNode(this.m_HMTRHierarchyWeight);
        this.m_Section.setEnabled(false);
    }

    public void addHMTRTargets(ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy) {
        if (this.isSectionHMTREnabled()) {
            ArrayList<ClusAttrType> attributes = schema.getAttr();
            ArrayList attrNames = new ArrayList();
            attributes.stream().forEach(a -> attrNames.add(a.getName()));
            ArrayList<String> aggregates = new ArrayList<String>();
            for (ClusHMTRNode node : hmtrHierarchy.getNodes()) {
                if (attrNames.contains(node.getName())) continue;
                node.setAggregate(true);
                aggregates.add(node.getName());
                schema.addAttrType(new NumericAttrType(node.getName()));
            }
            if (this.m_SettGeneral.getVerbose() > 0) {
                System.out.print("Aggregate attributes (a.k.a. not present in the database): ");
                ClusLogger.info(String.join((CharSequence)", ", aggregates));
                ClusLogger.info();
            }
            int nb = schema.getNbAttributes();
            String targets = this.m_SettAttribute.getTarget();
            int nbAggregates = aggregates.size();
            targets = targets + "," + (nb - nbAggregates + 1) + "-" + nb;
            this.m_SettAttribute.setTarget(targets);
            schema.setNbHMTRAttributes(nbAggregates);
        }
    }

    public static enum HierarchyTypesHMTR {
        Disabled,
        Tree,
        DAG;

    }

    public static enum HierarchyAggregationsHMTR {
        SUM,
        AVG,
        MEDIAN,
        MIN,
        MAX,
        AND,
        OR,
        COUNT,
        VAR,
        STDEV,
        ZERO,
        ONE;

    }

    public static enum HierarchyDistanceHMTR {
        WeightedEuclidean,
        Jaccard;

    }
}

