/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrDoubleOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsHMLC
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    protected INIFileEnum<HierarchyType> m_HierType;
    protected INIFileEnum<HierarchyWeight> m_HierWType;
    protected INIFileEnum<HierarchyDistance> m_HierDistance;
    protected INIFileDouble m_HierWParam;
    protected INIFileString m_HierSep;
    protected INIFileString m_HierEmptySetIndicator;
    protected INIFileEnum<HierarchyMeasures> m_HierOptimizeErrorMeasure;
    protected INIFileString m_DefinitionFile;
    protected INIFileBool m_HierNoRootPreds;
    protected INIFileBool m_HierSingleLabel;
    protected INIFileBool m_CalErr;
    protected INIFileDouble m_HierPruneInSig;
    protected INIFileBool m_HierUseBonferroni;
    protected INIFileNominalOrDoubleOrVector m_HierClassThreshold;
    protected INIFileNominalOrDoubleOrVector m_RecallValues;
    protected INIFileString m_HierEvalClasses;
    protected static INIFileBool m_HierUseMEstimate;

    public SettingsHMLC(int position) {
        super(position, "Hierarchical");
    }

    public void setSectionHierarchicalEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public boolean isSectionHierarchicalEnabled() {
        return this.m_Section.isEnabled();
    }

    public boolean getHierSingleLabel() {
        return this.m_HierSingleLabel.getValue();
    }

    public HierarchyType getHierType() {
        return this.m_HierType.getValue();
    }

    public HierarchyDistance getHierDistance() {
        return this.m_HierDistance.getValue();
    }

    public HierarchyWeight getHierWType() {
        return this.m_HierWType.getValue();
    }

    public double getHierWParam() {
        return this.m_HierWParam.getValue();
    }

    public boolean isCalError() {
        return this.m_CalErr.getValue();
    }

    public INIFileNominalOrDoubleOrVector getClassificationThresholds() {
        return this.m_HierClassThreshold;
    }

    public INIFileNominalOrDoubleOrVector getRecallValues() {
        return this.m_RecallValues;
    }

    public boolean isHierNoRootPreds() {
        return this.m_HierNoRootPreds.getValue();
    }

    public boolean isUseBonferroni() {
        return this.m_HierUseBonferroni.getValue();
    }

    public double getHierPruneInSig() {
        return this.m_HierPruneInSig.getValue();
    }

    public boolean hasHierEvalClasses() {
        return !StringUtils.unCaseCompare(this.m_HierEvalClasses.getValue(), "None");
    }

    public String getHierEvalClasses() {
        return this.m_HierEvalClasses.getValue();
    }

    public HierarchyMeasures getHierOptimizeErrorMeasure() {
        return this.m_HierOptimizeErrorMeasure.getValue();
    }

    public boolean hasDefinitionFile() {
        return !StringUtils.unCaseCompare(this.m_DefinitionFile.getValue(), "None");
    }

    public String getDefinitionFile() {
        return this.m_DefinitionFile.getValue();
    }

    public void initHierarchical() {
        ClassesValue.setHSeparator(this.m_HierSep.getValue());
        ClassesValue.setEmptySetIndicator(this.m_HierEmptySetIndicator.getValue());
    }

    public boolean useMEstimate() {
        return m_HierUseMEstimate.getValue();
    }

    @Override
    public void create() {
        this.m_HierType = new INIFileEnum<HierarchyType>("Type", HierarchyType.Unknown);
        this.m_Section.addNode(this.m_HierType);
        this.m_HierDistance = new INIFileEnum<HierarchyDistance>("Distance", HierarchyDistance.WeightedEuclidean);
        this.m_Section.addNode(this.m_HierDistance);
        this.m_HierWType = new INIFileEnum<HierarchyWeight>("WType", HierarchyWeight.ExpSumParentWeight);
        this.m_Section.addNode(this.m_HierWType);
        this.m_HierWParam = new INIFileDouble("WParam", 0.75);
        this.m_Section.addNode(this.m_HierWParam);
        this.m_HierSep = new INIFileString("HSeparator", ".");
        this.m_Section.addNode(this.m_HierSep);
        this.m_HierEmptySetIndicator = new INIFileString("EmptySetIndicator", "n");
        this.m_Section.addNode(this.m_HierEmptySetIndicator);
        this.m_HierOptimizeErrorMeasure = new INIFileEnum<HierarchyMeasures>("OptimizeErrorMeasure", HierarchyMeasures.PooledAUPRC);
        this.m_Section.addNode(this.m_HierOptimizeErrorMeasure);
        this.m_DefinitionFile = new INIFileString("DefinitionFile", "None");
        this.m_Section.addNode(this.m_DefinitionFile);
        this.m_HierNoRootPreds = new INIFileBool("NoRootPredictions", false);
        this.m_Section.addNode(this.m_HierNoRootPreds);
        this.m_HierPruneInSig = new INIFileDouble("PruneInSig", 0.0);
        this.m_Section.addNode(this.m_HierPruneInSig);
        this.m_HierUseBonferroni = new INIFileBool("Bonferroni", false);
        this.m_Section.addNode(this.m_HierUseBonferroni);
        this.m_HierSingleLabel = new INIFileBool("SingleLabel", false);
        this.m_Section.addNode(this.m_HierSingleLabel);
        this.m_CalErr = new INIFileBool("CalculateErrors", true);
        this.m_Section.addNode(this.m_CalErr);
        this.m_HierClassThreshold = new INIFileNominalOrDoubleOrVector("ClassificationThreshold", NONELIST);
        this.m_Section.addNode(this.m_HierClassThreshold);
        this.m_HierClassThreshold.setNominal(0);
        this.m_RecallValues = new INIFileNominalOrDoubleOrVector("RecallValues", NONELIST);
        this.m_Section.addNode(this.m_RecallValues);
        this.m_RecallValues.setNominal(0);
        this.m_HierEvalClasses = new INIFileString("EvalClasses", "None");
        this.m_Section.addNode(this.m_HierEvalClasses);
        m_HierUseMEstimate = new INIFileBool("MEstimate", false);
        this.m_Section.addNode(m_HierUseMEstimate);
        this.m_Section.setEnabled(false);
    }

    public static enum HierarchyType {
        Tree,
        DAG,
        Unknown;

    }

    public static enum HierarchyDistance {
        WeightedEuclidean,
        Jaccard,
        PooledAUPRC;

    }

    public static enum HierarchyWeight {
        NoWeight,
        ExpSumParentWeight,
        ExpAvgParentWeight,
        ExpMinParentWeight,
        ExpMaxParentWeight;

    }

    public static enum HierarchyMeasures {
        AverageAUROC,
        AverageAUPRC,
        WeightedAverageAUPRC,
        PooledAUPRC,
        Undefined;

    }
}

