/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsGeneral
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    INIFileInt m_Verbose;
    INIFileString m_RandomSeed;
    INIFileEnum<ResourceInfoLoad> m_ResourceInfoLoaded;
    INIFileBool m_DoNotInduce;
    INIFileString m_LoggingProperties;

    public SettingsGeneral(int position) {
        super(position, "General");
    }

    public int getVerbose() {
        return this.m_Verbose.getValue();
    }

    public int enableVerbose(int talk) {
        int prev = this.m_Verbose.getValue();
        this.m_Verbose.setValue(talk);
        return prev;
    }

    public boolean hasRandomSeed() {
        return !StringUtils.unCaseCompare(this.m_RandomSeed.getValue(), "None");
    }

    public int getRandomSeed() {
        return Integer.parseInt(this.m_RandomSeed.getValue());
    }

    public ResourceInfoLoad getResourceInfoLoadedValue() {
        return this.m_ResourceInfoLoaded.getValue();
    }

    public INIFileEnum<ResourceInfoLoad> getResourceInfoLoaded() {
        return this.m_ResourceInfoLoaded;
    }

    public boolean isDoNotInduce() {
        return this.m_DoNotInduce.getValue();
    }

    public String getLoggingProperties() {
        return this.m_LoggingProperties.getStringValue();
    }

    @Override
    public void create() {
        this.m_Verbose = new INIFileInt("Verbose", 1);
        this.m_Section.addNode(this.m_Verbose);
        this.m_RandomSeed = new INIFileString("RandomSeed", "0");
        this.m_Section.addNode(this.m_RandomSeed);
        this.m_ResourceInfoLoaded = new INIFileEnum<ResourceInfoLoad>("ResourceInfoLoaded", ResourceInfoLoad.No);
        this.m_Section.addNode(this.m_ResourceInfoLoaded);
        this.m_DoNotInduce = new INIFileBool("DoNotInduce", false);
        this.m_Section.addNode(this.m_DoNotInduce);
        this.m_LoggingProperties = new INIFileString("LoggingProperties", "logging.properties");
        this.m_Section.addNode(this.m_LoggingProperties);
    }

    public static enum ResourceInfoLoad {
        Yes,
        No,
        Test;

    }
}

