/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnumList;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNominalOrIntOrVector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.io.range.IntRangeCheck;

public class SettingsEnsemble
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    private INIFileNominalOrIntOrVector m_NbBags;
    private INIFileInt m_TimeBudget;
    private INIFileEnum<EnsembleBootstrapping> m_EnsembleBootstrapping;
    private INIFileEnum<EnsembleMethod> m_EnsembleMethod;
    private INIFileEnum<EnsembleVotingType> m_EnsembleVotingType;
    private INIFileString m_RandomAttrSelected;
    private INIFileString m_RandomTargetAttrSelected;
    private INIFileEnum<EnsembleROSAlgorithmType> m_EnsembleROSAlgorithmType;
    private INIFileEnum<EnsembleROSVotingType> m_EnsembleROSVotingType;
    private int m_SubsetSize;
    private INIFileBool m_PrintAllModels;
    private INIFileBool m_PrintAllModelFiles;
    private INIFileBool m_PrintAllModelInfo;
    private INIFileBool m_PrintPaths;
    private boolean m_EnsembleMode = false;
    private INIFileBool m_EnsembleShouldOpt;
    private INIFileBool m_EnsembleOOBestimate;
    private INIFileEnumList<EnsembleRanking> m_FeatureRanking;
    private INIFileString m_SymbolicWeight;
    public static final String DYNAMIC_WEIGHT = "Dynamic";
    private INIFileBool m_SortFeaturesByRelevance;
    private INIFileBool m_WriteEnsemblePredictions;
    private INIFileNominalOrIntOrVector m_BagSelection;
    private INIFileInt m_NumberOfThreads;
    private INIFileBool m_EnsembleRandomDepth;
    private INIFileInt m_EnsembleBagSize;
    private INIFileBool m_FeatureRankingPerTarget;

    public SettingsEnsemble(int position) {
        super(position, "Ensemble");
    }

    public boolean shouldPerformRankingPerTarget() {
        return this.m_FeatureRankingPerTarget.getValue();
    }

    public void setPerformRankingPerTarget(boolean b) {
        this.m_FeatureRankingPerTarget.setValue(b);
    }

    public boolean isEnsembleMode() {
        return this.m_EnsembleMode;
    }

    public void setEnsembleMode(boolean value) {
        this.m_EnsembleMode = value;
        this.setSectionEnsembleEnabled(value);
    }

    public boolean isSectionEnsembleEnabled() {
        return this.m_Section.isEnabled();
    }

    public void setSectionEnsembleEnabled(boolean value) {
        this.m_Section.setEnabled(value);
    }

    public EnsembleBootstrapping getEnsembleBootstrapping() {
        return this.m_EnsembleBootstrapping.getValue();
    }

    public EnsembleMethod getEnsembleMethod() {
        return this.m_EnsembleMethod.getValue();
    }

    public void setEnsembleMethod(String method) throws IOException {
        this.m_EnsembleMethod.setValue(method);
    }

    public EnsembleROSAlgorithmType getEnsembleROSAlgorithmType() {
        return this.m_EnsembleROSAlgorithmType.getValue();
    }

    public EnsembleROSVotingType getEnsembleROSVotingType() {
        return this.m_EnsembleROSVotingType.getValue();
    }

    public void setEnsembleROSVotingType(EnsembleROSVotingType value) {
        this.m_EnsembleROSVotingType.setValue(value);
    }

    public boolean isEnsembleROSEnabled() {
        return !this.getEnsembleROSAlgorithmType().equals((Object)EnsembleROSAlgorithmType.Disabled) && this.isEnsembleMode();
    }

    public List<EnsembleRanking> getRankingMethods() {
        return this.m_FeatureRanking.getValue();
    }

    public String getRankingMethodName() {
        return this.m_FeatureRanking.getValue().toString();
    }

    public boolean shouldPerformRanking() {
        return this.m_FeatureRanking.getVectorSize() > 0;
    }

    public void setFeatureRankingMethod(String value) throws IOException {
        this.m_FeatureRanking.setValue(value);
    }

    public INIFileNominalOrIntOrVector getNbBaggingSets() {
        if (!this.m_NbBags.isVector() && this.m_NbBags.getInt() == 0) {
            this.m_NbBags.setInt(100);
        }
        return this.m_NbBags;
    }

    public void setNbBags(int value) {
        this.m_NbBags.setInt(value);
    }

    public INIFileInt getTimeBudget() {
        return this.m_TimeBudget;
    }

    public void setTimeBudget(int value) {
        this.m_TimeBudget.setValue(value);
    }

    public int getNbRandomAttrSelected() {
        return this.m_SubsetSize;
    }

    public String getNbRandomAttrString() {
        return this.m_RandomAttrSelected.getValue();
    }

    public String getNbRandomTargetAttrString() {
        return this.m_RandomTargetAttrSelected.getValue();
    }

    public void setNbRandomTargetAttrString(String nbTargets) {
        this.m_RandomTargetAttrSelected.setValue(nbTargets);
    }

    public INIFileNominalOrIntOrVector getBagSelection() {
        return this.m_BagSelection;
    }

    public String[] getSymbolicWeights() {
        String s = this.m_SymbolicWeight.getValue();
        String[] values = s.startsWith("[") && s.endsWith("]") ? s.substring(1, s.length() - 1).split(",") : new String[]{s};
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public int calculateNbRandomAttrSelected(ClusSchema schema, RandomAttributeTypeSelection type) {
        String s;
        int ubound;
        String value;
        int fsize = -1;
        if (type.equals((Object)RandomAttributeTypeSelection.Descriptive)) {
            value = this.getNbRandomAttrString();
            ubound = schema.getNbDescriptiveAttributes();
            s = "descriptive";
        } else {
            value = this.getNbRandomTargetAttrString();
            ubound = schema.getNbTargetAttributes();
            s = "target";
        }
        if (value.contains("-")) {
            ClusLogger.severe("The number of subspaces can't be negative.");
            ClusLogger.severe("\t Setting this value to default (log2).");
            value = "0";
        }
        if (value.equalsIgnoreCase("SQRT") || value.equalsIgnoreCase("0")) {
            fsize = (int)Math.ceil(Math.sqrt(ubound));
        } else if (value.equalsIgnoreCase("LOG")) {
            fsize = (int)Math.ceil(Math.log(ubound) / Math.log(2.0));
        } else if (value.equalsIgnoreCase("RANDOM")) {
            fsize = -1;
        } else if (value.equalsIgnoreCase("RANDOMPERTREE")) {
            fsize = -2;
        } else {
            try {
                int val = Integer.parseInt(value);
                if (val > ubound) {
                    ClusLogger.severe("The size of the subset can't be larger than the number of " + s + " attributes.");
                    ClusLogger.severe("\t Setting this value to: the number of all attributes");
                    val = ubound;
                }
                fsize = val;
            }
            catch (NumberFormatException e) {
                try {
                    double val = Double.parseDouble(value);
                    if (val > 1.0) {
                        ClusLogger.severe("The fraction of the features used can't be larger than 1.");
                        ClusLogger.severe("\t Setting this value to 1, i.e., to bagging.");
                        val = 1.0;
                    }
                    fsize = (int)Math.ceil(val * (double)ubound);
                }
                catch (Exception e2) {
                    ClusLogger.severe("Error while setting the feature subset size!");
                    ClusLogger.severe("The set of possible values include:");
                    ClusLogger.severe("\t 0 or LOG for taking the log2,");
                    ClusLogger.severe("\t SQRT for taking the sqrt,");
                    ClusLogger.severe("\t RANDOM for taking a random subset of targets (works only in ensemble mode for target subspacing).");
                    ClusLogger.severe("\t integer for taking the absolute number of attributes,");
                    ClusLogger.severe("\t double (0,1) for taking the fraction values.");
                    System.exit(-1);
                }
            }
        }
        if (fsize < 0) {
            return fsize;
        }
        return Math.max(1, fsize);
    }

    public void updateNbRandomAttrSelected(ClusSchema schema) {
        int fsize = this.calculateNbRandomAttrSelected(schema, RandomAttributeTypeSelection.Descriptive);
        this.setNbRandomAttrSelected(fsize);
    }

    public void setNbRandomAttrSelected(int value) {
        this.m_SubsetSize = value;
        this.m_RandomAttrSelected.setValue(Integer.toString(value));
    }

    public void setBagSelection(int value) {
        this.m_BagSelection.setInt(value);
    }

    public boolean isVotingOOBWeighted() {
        return Arrays.asList(EnsembleVotingType.OOBModelWeighted, EnsembleVotingType.OOBTargetWeighted).contains((Object)this.getEnsembleVotingType());
    }

    public boolean isPrintEnsembleModels() {
        return this.m_PrintAllModels.getValue();
    }

    public boolean isPrintEnsembleModelFiles() {
        return this.m_PrintAllModelFiles.getValue();
    }

    public boolean isPrintEnsemblePaths() {
        return this.m_PrintPaths.getValue();
    }

    public boolean isPrintEnsembleModelInfo() {
        return this.m_PrintAllModelInfo.getValue();
    }

    public boolean shouldOptimizeEnsemble() {
        return this.m_EnsembleShouldOpt.getValue();
    }

    public boolean shouldSortRankingByRelevance() {
        return this.m_SortFeaturesByRelevance.getValue();
    }

    public boolean shouldWritePredictionsFromEnsemble() {
        return this.m_WriteEnsemblePredictions.getValue();
    }

    public boolean shouldEstimateOOB() {
        return this.m_EnsembleOOBestimate.getValue();
    }

    public void setOOBestimate(boolean value) {
        this.m_EnsembleOOBestimate.setValue(value);
    }

    public boolean isEnsembleRandomDepth() {
        return this.m_EnsembleRandomDepth.getValue();
    }

    public int getEnsembleBagSize() {
        return this.m_EnsembleBagSize.getValue();
    }

    public void setEnsembleBagSize(int value) {
        this.m_EnsembleBagSize.setValue(value);
    }

    public EnsembleVotingType getEnsembleVotingType() {
        return this.m_EnsembleVotingType.getValue();
    }

    public int getNumberOfThreads() {
        return this.m_NumberOfThreads.getValue();
    }

    public boolean isEnsembleWithParallelExecution() {
        return this.isEnsembleMode() && this.m_NumberOfThreads.getValue() > 1;
    }

    public String getEnsembleMethodName() {
        return this.getEnsembleMethod().toString();
    }

    @Override
    public void create() {
        this.m_NbBags = new INIFileNominalOrIntOrVector("Iterations", NONELIST);
        this.m_Section.addNode(this.m_NbBags);
        this.m_TimeBudget = new INIFileInt("TimeBudget", 0);
        this.m_Section.addNode(this.m_TimeBudget);
        this.m_EnsembleMethod = new INIFileEnum<EnsembleMethod>("EnsembleMethod", EnsembleMethod.Bagging);
        this.m_Section.addNode(this.m_EnsembleMethod);
        this.m_EnsembleBootstrapping = new INIFileEnum<EnsembleBootstrapping>("EnsembleBootstrapping", EnsembleBootstrapping.Undefined);
        this.m_Section.addNode(this.m_EnsembleBootstrapping);
        this.m_EnsembleVotingType = new INIFileEnum<EnsembleVotingType>("VotingType", EnsembleVotingType.ProbabilityDistribution);
        this.m_Section.addNode(this.m_EnsembleVotingType);
        this.m_RandomAttrSelected = new INIFileString("SelectRandomSubspaces", "0");
        this.m_Section.addNode(this.m_RandomAttrSelected);
        this.m_RandomTargetAttrSelected = new INIFileString("ROSTargetSubspaceSize", "SQRT");
        this.m_Section.addNode(this.m_RandomTargetAttrSelected);
        this.m_EnsembleROSAlgorithmType = new INIFileEnum<EnsembleROSAlgorithmType>("ROSAlgorithmType", EnsembleROSAlgorithmType.Disabled);
        this.m_Section.addNode(this.m_EnsembleROSAlgorithmType);
        this.m_EnsembleROSVotingType = new INIFileEnum<EnsembleROSVotingType>("ROSVotingType", EnsembleROSVotingType.SubspaceAveraging);
        this.m_Section.addNode(this.m_EnsembleROSVotingType);
        this.m_PrintAllModels = new INIFileBool("PrintAllModels", false);
        this.m_Section.addNode(this.m_PrintAllModels);
        this.m_PrintAllModelFiles = new INIFileBool("PrintAllModelFiles", false);
        this.m_Section.addNode(this.m_PrintAllModelFiles);
        this.m_PrintAllModelInfo = new INIFileBool("PrintAllModelInfo", false);
        this.m_Section.addNode(this.m_PrintAllModelInfo);
        this.m_PrintPaths = new INIFileBool("PrintPaths", false);
        this.m_Section.addNode(this.m_PrintPaths);
        this.m_EnsembleShouldOpt = new INIFileBool("Optimize", false);
        this.m_Section.addNode(this.m_EnsembleShouldOpt);
        this.m_EnsembleOOBestimate = new INIFileBool("OOBestimate", false);
        this.m_Section.addNode(this.m_EnsembleOOBestimate);
        this.m_FeatureRanking = new INIFileEnumList<EnsembleRanking>("FeatureRanking", Arrays.asList(new EnsembleRanking[0]), EnsembleRanking.class);
        this.m_Section.addNode(this.m_FeatureRanking);
        this.m_FeatureRankingPerTarget = new INIFileBool("FeatureRankingPerTarget", false);
        this.m_Section.addNode(this.m_FeatureRankingPerTarget);
        this.m_SymbolicWeight = new INIFileString("SymbolicWeight", "0.5");
        this.m_Section.addNode(this.m_SymbolicWeight);
        this.m_SortFeaturesByRelevance = new INIFileBool("SortRankingByRelevance", true);
        this.m_Section.addNode(this.m_SortFeaturesByRelevance);
        this.m_WriteEnsemblePredictions = new INIFileBool("WriteEnsemblePredictions", false);
        this.m_Section.addNode(this.m_WriteEnsemblePredictions);
        this.m_EnsembleRandomDepth = new INIFileBool("EnsembleRandomDepth", false);
        this.m_Section.addNode(this.m_EnsembleRandomDepth);
        this.m_BagSelection = new INIFileNominalOrIntOrVector("BagSelection", NONELIST);
        this.m_Section.addNode(this.m_BagSelection);
        this.m_BagSelection.setInt(-1);
        this.m_EnsembleBagSize = new INIFileInt("BagSize", 0);
        this.m_Section.addNode(this.m_EnsembleBagSize);
        this.m_EnsembleBagSize.setValueCheck(new IntRangeCheck(0, Integer.MAX_VALUE));
        this.m_NumberOfThreads = new INIFileInt("NumberOfThreads", 1);
        this.m_Section.addNode(this.m_NumberOfThreads);
        this.m_NumberOfThreads.setValueCheck(new IntRangeCheck(0, 200));
        this.m_Section.setEnabled(false);
    }

    @Override
    public List<String> validateSettingsInternal() {
        ArrayList<String> incompatible = new ArrayList<String>();
        HashMap<EnsembleROSAlgorithmType, List<EnsembleROSVotingType>> validROSCombinations = new HashMap<EnsembleROSAlgorithmType, List<EnsembleROSVotingType>>();
        validROSCombinations.put(EnsembleROSAlgorithmType.FixedSubspaces, Arrays.asList(EnsembleROSVotingType.TotalAveraging, EnsembleROSVotingType.SubspaceAveraging));
        validROSCombinations.put(EnsembleROSAlgorithmType.DynamicSubspaces, Arrays.asList(EnsembleROSVotingType.TotalAveraging, EnsembleROSVotingType.SubspaceAveraging));
        if (!this.getEnsembleROSAlgorithmType().equals((Object)EnsembleROSAlgorithmType.Disabled) && !((List)validROSCombinations.get((Object)this.getEnsembleROSAlgorithmType())).contains((Object)this.getEnsembleROSVotingType())) {
            incompatible.add(SettingsEnsemble.formatInvalid(this.m_EnsembleROSAlgorithmType, (Object)this.getEnsembleROSAlgorithmType(), String.format("Cannot be used with %s = %s", new Object[]{this.m_EnsembleROSVotingType.getName(), this.getEnsembleROSVotingType()})));
        }
        if (this.isEnsembleMode()) {
            EnsembleMethod m = this.getEnsembleMethod();
            List<EnsembleMethod> allowed = Arrays.asList(EnsembleMethod.Bagging, EnsembleMethod.RForest, EnsembleMethod.ExtraTrees);
            if (this.shouldPerformRanking() && !allowed.contains((Object)m)) {
                incompatible.add(String.format("Feature Ranking not implemented for %s", m.name()));
            }
        }
        return incompatible;
    }

    public void determineBoostrapping() {
        EnsembleMethod ens = this.getEnsembleMethod();
        EnsembleBootstrapping chosen = this.getEnsembleBootstrapping();
        EnsembleBootstrapping def = ens.ShouldBootstrapData;
        if (chosen.equals((Object)EnsembleBootstrapping.Undefined)) {
            this.m_EnsembleBootstrapping.setValue(def);
        } else if (!ens.equals((Object)EnsembleMethod.ExtraTrees) && !chosen.equals((Object)def)) {
            ClusLogger.severe("Bootstrapping value changed to default: " + (Object)((Object)def));
            this.m_EnsembleBootstrapping.setValue(def);
        }
    }

    public static enum EnsembleBootstrapping {
        Yes,
        No,
        Undefined;

    }

    public static enum EnsembleMethod {
        Bagging(EnsembleBootstrapping.Yes),
        RForest(EnsembleBootstrapping.Yes),
        RSubspaces(EnsembleBootstrapping.No),
        BagSubspaces(EnsembleBootstrapping.Yes),
        Boosting(EnsembleBootstrapping.No),
        RFeatSelection(EnsembleBootstrapping.No),
        Pert(EnsembleBootstrapping.Yes),
        ExtraTrees(EnsembleBootstrapping.No);

        EnsembleBootstrapping ShouldBootstrapData = null;

        private EnsembleMethod(EnsembleBootstrapping bt) {
            this.ShouldBootstrapData = bt;
        }
    }

    public static enum EnsembleROSAlgorithmType {
        Disabled,
        FixedSubspaces,
        DynamicSubspaces;

    }

    public static enum EnsembleROSVotingType {
        TotalAveraging,
        SubspaceAveraging;

    }

    public static enum RandomAttributeTypeSelection {
        Descriptive,
        Clustering;

    }

    public static enum EnsembleVotingType {
        Majority,
        ProbabilityDistribution,
        OOBModelWeighted,
        OOBTargetWeighted;

    }

    public static enum EnsembleRanking {
        RForest,
        Genie3,
        Symbolic;

    }
}

