/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings.section;

import si.ijs.kt.clus.main.settings.SettingsBase;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileBool;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileDouble;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEnum;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileInt;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileString;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class SettingsBeamSearch
extends SettingsBase {
    private static final long serialVersionUID = 1L;
    public static int BEAM_WIDTH;
    public static double SIZE_PENALTY;
    public static double BEAM_SIMILARITY;
    public static boolean BEAM_SYNT_DIST_CONSTR;
    protected INIFileDouble m_SizePenalty;
    protected INIFileInt m_BeamWidth;
    protected INIFileInt m_BeamBestN;
    protected INIFileInt m_TreeMaxSize;
    protected INIFileEnum<SettingsTree.Heuristic> m_BeamAttrHeuristic;
    protected INIFileBool m_FastBS;
    protected INIFileBool m_BeamPostPrune;
    protected INIFileBool m_BMRemoveEqualHeur;
    protected INIFileDouble m_BeamSimilarity;
    protected INIFileBool m_BSortTrainParameter;
    protected INIFileBool m_BeamToForest;
    protected INIFileString m_BeamSyntacticConstrFile;

    public SettingsBeamSearch(int position) {
        super(position, "Beam");
    }

    public void setSectionBeamEnabled(boolean enable) {
        this.m_Section.setEnabled(enable);
    }

    public int getBeamWidth() {
        return this.m_BeamWidth.getValue();
    }

    public double getSizePenalty() {
        return this.m_SizePenalty.getValue();
    }

    public boolean isBeamSearchMode() {
        return this.m_Section.isEnabled();
    }

    public int getBeamBestN() {
        return this.m_BeamBestN.getValue();
    }

    public int getBeamTreeMaxSize() {
        return this.m_TreeMaxSize.getValue();
    }

    public boolean getBeamRemoveEqualHeur() {
        return this.m_BMRemoveEqualHeur.getValue();
    }

    public boolean getBeamSortOnTrainParameter() {
        return this.m_BSortTrainParameter.getValue();
    }

    public double getBeamSimilarity() {
        return this.m_BeamSimilarity.getValue();
    }

    public boolean isBeamPostPrune() {
        return this.m_BeamPostPrune.getValue();
    }

    public SettingsTree.Heuristic getBeamAttrHeuristic() {
        return this.m_BeamAttrHeuristic.getValue();
    }

    public boolean hasBeamConstraintFile() {
        return !StringUtils.unCaseCompare(this.m_BeamSyntacticConstrFile.getValue(), "None");
    }

    public String getBeamConstraintFile() {
        return this.m_BeamSyntacticConstrFile.getValue();
    }

    public boolean isBeamToForest() {
        return this.m_BeamToForest.getValue();
    }

    public boolean isFastBS() {
        return this.m_FastBS.getValue();
    }

    @Override
    public void create() {
        this.m_SizePenalty = new INIFileDouble("SizePenalty", 0.1);
        this.m_Section.addNode(this.m_SizePenalty);
        this.m_BeamWidth = new INIFileInt("BeamWidth", 10);
        this.m_Section.addNode(this.m_BeamWidth);
        this.m_BeamBestN = new INIFileInt("BeamBestN", 5);
        this.m_Section.addNode(this.m_BeamBestN);
        this.m_TreeMaxSize = new INIFileInt("MaxSize", -1);
        this.m_Section.addNode(this.m_TreeMaxSize);
        this.m_BeamAttrHeuristic = new INIFileEnum<SettingsTree.Heuristic>("AttributeHeuristic", SettingsTree.Heuristic.Default);
        this.m_Section.addNode(this.m_BeamAttrHeuristic);
        this.m_FastBS = new INIFileBool("FastSearch", true);
        this.m_Section.addNode(this.m_FastBS);
        this.m_BeamPostPrune = new INIFileBool("PostPrune", false);
        this.m_Section.addNode(this.m_BeamPostPrune);
        this.m_BMRemoveEqualHeur = new INIFileBool("RemoveEqualHeur", false);
        this.m_Section.addNode(this.m_BMRemoveEqualHeur);
        this.m_BeamSimilarity = new INIFileDouble("BeamSimilarity", 0.0);
        this.m_Section.addNode(this.m_BeamSimilarity);
        this.m_BSortTrainParameter = new INIFileBool("BeamSortOnTrainParameteres", false);
        this.m_Section.addNode(this.m_BSortTrainParameter);
        this.m_BeamSyntacticConstrFile = new INIFileString("DistSyntacticConstr", "None");
        this.m_Section.addNode(this.m_BeamSyntacticConstrFile);
        this.m_BeamToForest = new INIFileBool("BeamToForest", false);
        this.m_Section.addNode(this.m_BeamToForest);
        this.m_Section.setEnabled(false);
    }

    @Override
    public void initNamedValues() {
        this.m_TreeMaxSize.setNamedValue(-1, "Infinity");
    }
}

