/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main.settings;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileSection;

public abstract class SettingsBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT = "Default";
    public static final String NONE = "None";
    public static final String[] NONELIST = new String[]{"None"};
    public static final String[] EMPTY = new String[0];
    public static final String[] INFINITY = new String[]{"Infinity"};
    public static final String INFINITY_STRING = "Infinity";
    public static final int INFINITY_VALUE = 0;
    public static final double[] FOUR_ONES = new double[]{1.0, 1.0, 1.0, 1.0};
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    protected int m_Position = 1;
    protected INIFileSection m_Section;

    public SettingsBase(int position, String name) {
        this.m_Position = position;
        this.m_Section = new INIFileSection(name);
    }

    public abstract void create();

    public void initNamedValues() {
    }

    public List<String> validateSettingsInternal() {
        return null;
    }

    public int getPosition() {
        return this.m_Position;
    }

    public INIFileSection getSection() {
        return this.m_Section;
    }

    public static String formatInvalid(INIFileEntry settingEntry, Object settingValue) {
        return SettingsBase.formatInvalid(settingEntry, settingValue, null);
    }

    public static String formatInvalid(INIFileEntry settingEntry, Object settingValue, String additionalMessage) {
        return String.format("%s = %s is invalid %s", settingEntry.getName(), settingValue, additionalMessage == null ? "" : "=> Additional info: " + additionalMessage);
    }

    public static enum YesNo {
        Yes,
        No;

    }
}

