/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.main;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.TupleIterator;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.ensemble.ClusReadWriteLock;
import si.ijs.kt.clus.main.ClusModelInfoList;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.ClusSummary;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusRun
extends ClusModelInfoList {
    public static final long serialVersionUID = 1L;
    protected int m_Index = 1;
    protected boolean m_FileTestSet;
    protected ClusData m_Train;
    protected ClusData m_Prune;
    protected ClusData m_Orig;
    protected ClusSelection m_TestSel;
    protected ClusSelection m_PruneSel;
    protected TupleIterator m_Test;
    protected TupleIterator m_UnlabeledData;
    protected ClusSummary m_Summary;
    private boolean m_IsInternalXValRun = false;
    ClusReadWriteLock m_Lock = new ClusReadWriteLock();

    public ClusRun(ClusData train, ClusSummary summary) {
        this.m_Train = train;
        this.m_Summary = summary;
    }

    public ClusRun(ClusRun other) throws ClusException {
        this.m_Train = other.m_Train;
        this.m_Prune = other.m_Prune;
        this.m_Orig = other.m_Orig;
        this.m_TestSel = other.m_TestSel;
        this.m_PruneSel = other.m_PruneSel;
        this.m_Test = other.m_Test;
        this.m_UnlabeledData = other.m_UnlabeledData;
        this.m_Summary = other.m_Summary.getSummaryClone();
        this.setModels(other.cloneModels());
        this.m_IsInternalXValRun = other.m_IsInternalXValRun;
    }

    @Override
    public ClusStatManager getStatManager() {
        return this.m_Summary.getStatManager();
    }

    public void setClusteringWeights(ClusAttributeWeights weights) {
        this.m_Summary.m_StatMgr.m_ClusteringWeights.m_Weights = weights.m_Weights;
    }

    public ClusSummary getSummary() {
        return this.m_Summary;
    }

    @Override
    public ClusErrorList getTrainError() {
        return this.m_Summary.getTrainError();
    }

    @Override
    public ClusErrorList getTestError() {
        return this.m_Summary.getTestError();
    }

    @Override
    public ClusErrorList getValidationError() {
        return this.m_Summary.getValidationError();
    }

    public final int getIndex() {
        return this.m_Index;
    }

    public final void setIndex(int idx) {
        this.m_Index = idx;
    }

    public final String getIndexString() {
        String ridx = String.valueOf(this.getIndex());
        if (this.getIndex() < 10) {
            ridx = "0" + ridx;
        }
        return ridx;
    }

    public final ClusData getOriginalSet() {
        return this.m_Orig;
    }

    public final void setOrigSet(ClusData data) {
        this.m_Orig = data;
    }

    public final RowData getDataSet(int whichone) throws ClusException, IOException, InterruptedException {
        switch (whichone) {
            case 0: {
                return (RowData)this.getTrainingSet();
            }
            case 1: {
                return this.getTestSet();
            }
            case 2: {
                return (RowData)this.getPruneSet();
            }
        }
        return null;
    }

    public final ClusData getTrainingSet() throws InterruptedException {
        this.m_Lock.readingLock();
        ClusData train = this.m_Train;
        this.m_Lock.readingUnlock();
        return train;
    }

    public final void setTrainingSet(ClusData data) {
        this.m_Train = data;
    }

    public final TupleIterator getTrainIter() {
        return ((RowData)this.m_Train).getIterator();
    }

    public final void copyTrainingData() {
        RowData clone = (RowData)this.m_Train.cloneData();
        this.setTrainingSet(clone);
    }

    public final ClusSelection getTestSelection() {
        return this.m_TestSel;
    }

    public final void setTestSet(TupleIterator iter) {
        this.m_Test = iter;
    }

    public final TupleIterator getTestIter() {
        return this.m_Test;
    }

    public final RowData getTestSet() throws IOException, ClusException {
        if (this.m_Test == null) {
            return null;
        }
        RowData data = (RowData)this.m_Test.getData();
        if (data == null) {
            data = (RowData)this.m_Test.createInMemoryData();
            this.m_Test = data.getIterator();
        }
        return data;
    }

    public final ClusData getPruneSet() {
        return this.m_Prune;
    }

    public final TupleIterator getPruneIter() {
        return ((RowData)this.m_Prune).getIterator();
    }

    public final void setPruneSet(ClusData data, ClusSelection sel) {
        this.m_Prune = data;
        this.m_PruneSel = sel;
    }

    public final ClusSelection getPruneSelection() {
        return this.m_PruneSel;
    }

    public void combineTrainAndValidSets() throws InterruptedException, ClusException {
        RowData valid = (RowData)this.getPruneSet();
        if (valid != null) {
            RowData train = (RowData)this.getTrainingSet();
            ArrayList<DataTuple> lst = train.toArrayList();
            lst.addAll(valid.toArrayList());
            this.setTrainingSet(new RowData(lst, train.getSchema()));
            this.setPruneSet(null, null);
            this.changePruneError(null);
            this.copyTrainingData();
        }
    }

    public final void setUnlabeledSet(TupleIterator iter) {
        this.m_UnlabeledData = iter;
    }

    public final TupleIterator getUnlabeledIter() {
        return this.m_UnlabeledData;
    }

    public final RowData getUnlabeledSet() throws IOException, ClusException {
        if (this.m_UnlabeledData == null) {
            return null;
        }
        RowData data = (RowData)this.m_UnlabeledData.getData();
        if (data == null) {
            data = (RowData)this.m_UnlabeledData.createInMemoryData();
            this.m_UnlabeledData = data.getIterator();
        }
        return data;
    }

    public void changeTestError(ClusErrorList par) throws ClusException {
        this.m_Summary.setTestError(par);
        int nb_models = this.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            my.setTestError(par.getErrorClone());
        }
    }

    public void changePruneError(ClusErrorList par) throws ClusException {
        this.m_Summary.setValidationError(par);
        int nb_models = this.getNbModels();
        for (int i = 0; i < nb_models; ++i) {
            ClusModelInfo my = this.getModelInfo(i);
            my.setValidationError(par != null ? par.getErrorClone() : null);
        }
    }

    public void deleteData() {
        this.m_Train = null;
        this.m_Prune = null;
        this.m_Orig = null;
        this.m_TestSel = null;
        this.m_PruneSel = null;
        this.m_Test = null;
    }

    public void deleteDataAndModels() {
        this.deleteData();
        this.deleteModels();
    }

    public boolean getIsInternalXValRun() {
        return this.m_IsInternalXValRun;
    }

    public void setIsInternalXValRun(boolean v) {
        this.m_IsInternalXValRun = v;
    }
}

