/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic.rules;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersion;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;

public class ClusRuleHeuristicRDispersionMlt
extends ClusRuleHeuristicDispersion {
    public ClusRuleHeuristicRDispersionMlt(ClusStatManager stat_mgr, ClusAttributeWeights prod, Settings sett) {
        super(sett);
        this.m_StatManager = stat_mgr;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_pos = c_pstat.getTotalWeight();
        if (n_pos - SettingsTree.MINIMAL_WEIGHT < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        double disp = ((CombStat)c_pstat).rDispersionMltHeur();
        if (((CombStat)c_pstat).getSettings().getRules().isHeurRuleDist() && this.m_CoveredBitVectArray.size() > 0) {
            double avg_dist = 0.0;
            int nb_rules = this.m_CoveredBitVectArray.size();
            boolean[] bit_vect = new boolean[this.m_NbTuples];
            for (int i = 0; i < this.m_DataIndexes.length; ++i) {
                bit_vect[this.m_DataIndexes[i]] = true;
            }
            boolean[] bit_vect_c = new boolean[this.m_NbTuples];
            for (int j = 0; j < nb_rules; ++j) {
                bit_vect_c = (boolean[])this.m_CoveredBitVectArray.get(j);
                double single_dist = 0.0;
                for (int i = 0; i < this.m_NbTuples; ++i) {
                    if (bit_vect[i] == bit_vect_c[i]) continue;
                    single_dist += 1.0;
                }
                avg_dist += (single_dist /= (double)this.m_NbTuples);
            }
            double dist_par = ((CombStat)c_pstat).getSettings().getRules().getHeurRuleDistPar();
            disp = avg_dist > 0.0 ? disp / Math.pow(avg_dist /= (double)nb_rules, dist_par) : 100.0;
        }
        return -disp;
    }

    @Override
    public String getName() {
        return "Rule Heuristic (Reduced Relative Dispersion, Multiplicative ver.)";
    }
}

