/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic.rules;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusRuleHeuristicError
extends ClusHeuristic {
    private ClusStatManager m_StatManager = null;

    public ClusRuleHeuristicError(ClusStatManager stat_mgr, ClusAttributeWeights prod, Settings sett) {
        super(sett);
        this.m_StatManager = stat_mgr;
        this.m_ClusteringWeights = prod;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_pos = c_pstat.getTotalWeight();
        if (n_pos - SettingsTree.MINIMAL_WEIGHT < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        double pos_error = c_pstat.getError(this.m_ClusteringWeights);
        double global_sum_w = this.m_StatManager.getTrainSetStat(ClusAttrType.AttributeUseType.Clustering).getTotalWeight();
        double heur_par = this.getSettings().getRules().getHeurCoveragePar();
        return -(pos_error *= 1.0 + heur_par * global_sum_w / c_pstat.getTotalWeight());
    }

    @Override
    public String getName() {
        return "Rule Heuristic (Reduced Error)";
    }
}

