/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic.hierarchical;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusRuleHeuristicHierarchical
extends ClusHeuristic {
    protected ClusStatManager m_StatManager;

    public ClusRuleHeuristicHierarchical(ClusStatManager stat_mgr, ClusAttributeWeights prod, Settings sett) {
        super(sett);
        this.m_StatManager = stat_mgr;
        this.m_ClusteringWeights = prod;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_pos = c_pstat.getTotalWeight();
        if (n_pos - SettingsTree.MINIMAL_WEIGHT < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        double totalValue = this.getTrainDataHeurValue();
        double ruleValue = c_pstat.getSVarS(this.m_ClusteringWeights);
        double value = totalValue - ruleValue;
        double train_sum_w = this.m_StatManager.getTrainSetStat(ClusAttrType.AttributeUseType.Clustering).getTotalWeight();
        double coverage = n_pos / train_sum_w;
        double cov_par = this.m_StatManager.getSettings().getRules().getHeurCoveragePar();
        coverage = Math.pow(coverage, cov_par);
        return value *= coverage;
    }

    @Override
    public String getName() {
        return "RuleHeuristicHierarchical";
    }
}

