/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.FTest;
import si.ijs.kt.clus.util.exception.ClusException;

public class VarianceReductionHeuristicEfficient
extends ClusHeuristic {
    private ClusAttrType[] m_Attrs;

    public VarianceReductionHeuristicEfficient(ClusAttributeWeights prod, ClusAttrType[] attrs, Settings sett) {
        super(sett);
        this.m_ClusteringWeights = prod;
        this.m_Attrs = attrs;
    }

    @Override
    public boolean isEfficient() {
        return true;
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing, double ss_tot) {
        if (this.stopCriterion(tstat, pstat, missing)) {
            return Double.NEGATIVE_INFINITY;
        }
        double ss_pos = pstat.getSVarS(this.m_ClusteringWeights);
        double ss_neg = tstat.getSVarSDiff(this.m_ClusteringWeights, pstat);
        return FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_pos + ss_neg);
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing) {
        if (this.stopCriterion(tstat, pstat, missing)) {
            return Double.NEGATIVE_INFINITY;
        }
        double ss_tot = tstat.getSVarS(this.m_ClusteringWeights);
        double ss_pos = pstat.getSVarS(this.m_ClusteringWeights);
        double ss_neg = tstat.getSVarSDiff(this.m_ClusteringWeights, pstat);
        return FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_pos + ss_neg);
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic[] pstat, int nbsplit) {
        if (this.stopCriterion(tstat, pstat, nbsplit)) {
            return Double.NEGATIVE_INFINITY;
        }
        double ss_sum = 0.0;
        for (int i = 0; i < nbsplit; ++i) {
            ss_sum += pstat[i].getSVarS(this.m_ClusteringWeights);
        }
        double ss_tot = tstat.getSVarS(this.m_ClusteringWeights);
        return FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_sum);
    }

    @Override
    public String getName() {
        return "Variance Reduction (FTest = " + SettingsTree.FTEST_VALUE + ", " + this.m_ClusteringWeights.getName(this.m_Attrs) + ")";
    }

    public void printInfo(double ss_tot, double ss_pos, double ss_neg, ClusStatistic pstat) throws ClusException {
        pstat.calcMean();
        ClusLogger.info("C-pos: " + pstat);
        ClusLogger.info("SS-pos: " + ss_pos + " SS-neg: " + ss_neg + " -> " + (ss_tot - (ss_pos + ss_neg)));
    }
}

