/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ReducedErrorHeuristic
extends ClusHeuristic {
    private double m_NbTrain;
    ClusStatistic m_Pos;
    ClusStatistic m_Neg;

    public ReducedErrorHeuristic(ClusStatistic stat, Settings sett) {
        super(sett);
        this.m_Pos = stat;
        this.m_Neg = stat.cloneStat();
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_tot = c_tstat.getTotalWeight();
        double n_pos = c_pstat.getTotalWeight();
        double n_neg = n_tot - n_pos;
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        if (missing.getTotalWeight() <= 1.0E-9) {
            double pos_error = c_pstat.getError();
            double neg_error = c_tstat.getErrorDiff(c_pstat);
            return -(pos_error + neg_error) / this.m_NbTrain;
        }
        double pos_freq = n_pos / n_tot;
        this.m_Pos.copy(c_pstat);
        this.m_Neg.copy(c_tstat);
        this.m_Neg.subtractFromThis(c_pstat);
        this.m_Pos.addScaled(pos_freq, missing);
        this.m_Neg.addScaled(1.0 - pos_freq, missing);
        double pos_error = this.m_Pos.getError();
        double neg_error = this.m_Neg.getError();
        return -(pos_error + neg_error) / this.m_NbTrain;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic[] c_pstat, int nbsplit) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setRootStatistic(ClusStatistic stat) {
        this.m_NbTrain = stat.getTotalWeight();
    }

    @Override
    public String getName() {
        return "Reduced Error Heuristic";
    }
}

