/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.GeneticDistanceStat;
import si.ijs.kt.clus.util.ClusLogger;

public abstract class GeneticDistanceHeuristic
extends ClusHeuristic {
    protected RowData m_Data;
    protected RowData m_RootData;
    protected int[] m_DataIndices;
    protected int[] m_ComplDataIndices;

    public GeneticDistanceHeuristic(Settings sett) {
        super(sett);
    }

    @Override
    public String getName() {
        return "GeneticDistanceHeuristic";
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
        this.m_DataIndices = this.constructIndexVector(this.m_Data);
        this.m_ComplDataIndices = this.constructComplIndexVector(this.m_RootData, this.m_DataIndices);
    }

    public int[] constructIndexVector(RowData data) {
        int nb = data.getNbRows();
        int[] resultvector = new int[nb];
        for (int i = 0; i < nb; ++i) {
            int index;
            resultvector[i] = index = data.getTuple(i).getIndex();
        }
        return resultvector;
    }

    public int[] constructIndexVector(RowData data, ClusStatistic stat) {
        GeneticDistanceStat gstat = (GeneticDistanceStat)stat;
        int nb = (int)gstat.getTotalWeight();
        int[] resultvector = new int[nb];
        for (int i = 0; i < nb; ++i) {
            int origindex;
            int tupleindex = gstat.getTupleIndex(i);
            resultvector[i] = origindex = data.getTuple(tupleindex).getIndex();
        }
        return resultvector;
    }

    public int[] constructComplIndexVector(RowData data, int[] indices) {
        int totalnb = data.getNbRows();
        int indnb = indices.length;
        int complnb = totalnb - indnb;
        int[] resultvector = new int[complnb];
        int indexpos = 0;
        int currindex = indices[indexpos];
        int j = 0;
        for (int i = 0; i < totalnb; ++i) {
            int index = data.getTuple(i).getIndex();
            if (currindex > index) {
                resultvector[j] = index;
                ++j;
                continue;
            }
            if (currindex == index) {
                if (++indexpos >= indnb) {
                    currindex = 1000000;
                    continue;
                }
                currindex = indices[indexpos];
                continue;
            }
            if (currindex >= index) continue;
            System.err.println("GeneticDistanceHeuristic : Something is wrong with datatuple indices!");
        }
        return resultvector;
    }

    public double getDistance(String[] seq1, String[] seq2) {
        switch (this.getSettings().getPhylogeny().getPhylogenyDM()) {
            case Edit: {
                return this.getEditDistance(seq1, seq2);
            }
            case PDist: {
                return this.getPDistance(seq1, seq2);
            }
            case JC: {
                return this.getJukesCantorDistance(seq1, seq2);
            }
            case Kimura: {
                return this.getKimuraDistance(seq1, seq2);
            }
            case AminoKimura: {
                return this.getAminoKimuraDistance(seq1, seq2);
            }
        }
        return 0.0;
    }

    public double getEditDistance(String[] seq1, String[] seq2) {
        double p = 0.0;
        for (int i = 0; i < seq1.length; ++i) {
            if (seq1[i].equals(seq2[i])) continue;
            p += 1.0;
        }
        return p;
    }

    public double getPDistance(String[] seq1, String[] seq2) {
        double p = 0.0;
        int nb = 0;
        for (int i = 0; i < seq1.length; ++i) {
            if (seq1[i].equals("?") || seq2[i].equals("?") || seq1[i].equals("-") || seq2[i].equals("-")) continue;
            if (!seq1[i].equals(seq2[i])) {
                p += 1.0;
                ++nb;
                continue;
            }
            ++nb;
        }
        double p_distance = p / (double)nb;
        if (p_distance == Double.POSITIVE_INFINITY) {
            ClusLogger.info("p: " + p + " nb: " + nb + " " + seq1 + " " + seq2);
        }
        if (p_distance == Double.NEGATIVE_INFINITY) {
            ClusLogger.info("p: " + p + " nb: " + nb + " " + seq1 + " " + seq2);
        }
        return p_distance;
    }

    public double getJukesCantorDistance(String[] seq1, String[] seq2) {
        double jk_distance;
        double p_distance = this.getPDistance(seq1, seq2);
        if (p_distance > 0.749) {
            jk_distance = 2.1562;
            ClusLogger.info("Warning: infinite Jukes Cantor distance (p-distance => 0.75), set to 2.1562");
        } else {
            jk_distance = -0.75 * Math.log(1.0 - 4.0 * p_distance / 3.0);
        }
        return jk_distance;
    }

    public double getKimuraDistance(String[] seq1, String[] seq2) {
        int nb = 0;
        int ti = 0;
        int tv = 0;
        for (int i = 0; i < seq1.length; ++i) {
            if (seq1[i].equals("?") || seq2[i].equals("?") || seq1[i].equals("-") || seq2[i].equals("-")) continue;
            ++nb;
            if (seq1[i].equals(seq2[i])) continue;
            if (seq1[i].equals("A")) {
                if (seq2[i].equals("G")) {
                    ++ti;
                    continue;
                }
                ++tv;
                continue;
            }
            if (seq1[i].equals("C")) {
                if (seq2[i].equals("T")) {
                    ++ti;
                    continue;
                }
                ++tv;
                continue;
            }
            if (seq1[i].equals("G")) {
                if (seq2[i].equals("A")) {
                    ++ti;
                    continue;
                }
                ++tv;
                continue;
            }
            if (!seq1[i].equals("T")) continue;
            if (seq2[i].equals("C")) {
                ++ti;
                continue;
            }
            ++tv;
        }
        double ti_ratio = (double)ti / (double)nb;
        double tv_ratio = (double)tv / (double)nb;
        double term1 = Math.log10(1.0 / (1.0 - 2.0 * ti_ratio - tv_ratio));
        double term2 = Math.log10(1.0 / (1.0 - 2.0 * tv_ratio));
        double kimura = term1 + term2;
        return kimura;
    }

    public double getAminoKimuraDistance(String[] seq1, String[] seq2) {
        double kimura;
        double p_distance = this.getPDistance(seq1, seq2);
        if (p_distance > 0.8541) {
            kimura = 12.84;
            ClusLogger.info("Warning: infinite AminoKimura distances (p-distance > 0.85), set to 12.84");
        } else {
            kimura = -1.0 * Math.log(1.0 - p_distance - 0.2 * Math.pow(p_distance, 2.0));
        }
        return kimura;
    }
}

