/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.FTest;
import si.ijs.kt.clus.util.jeans.math.MathUtil;

public class GISHeuristic
extends ClusHeuristic {
    protected String m_BasicDist;
    private ClusAttributeWeights m_ClusteringWeights;
    protected boolean m_GainRatio;
    protected RowData m_Data;
    protected int[] m_DataIndices;
    protected ClusStatistic m_Pos;
    protected ClusStatistic m_Neg;
    public static HashMap<Long, Double> m_distances = new HashMap();
    public static HashMap<String, Double> m_distancesN = new HashMap();
    public static HashMap<String, Double> m_distancesS = new HashMap();
    private boolean m_WarningGiven = false;

    public GISHeuristic(ClusAttributeWeights prod, ClusAttrType[] attrs, Settings sett) {
        super(sett);
        this.m_ClusteringWeights = prod;
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
        this.m_DataIndices = this.constructIndexVector(this.m_Data);
    }

    @Override
    public void setInitialData(ClusStatistic stat, RowData data) {
        this.m_Data = data;
        this.m_Data.addIndices();
        this.m_Pos = stat;
        this.m_Neg = stat.cloneStat();
    }

    public int[] constructIndexVector(RowData data) {
        int nb = data.getNbRows();
        int[] resultvector = new int[nb];
        for (int i = 0; i < nb; ++i) {
            int index;
            resultvector[i] = index = data.getTuple(i).getIndex();
        }
        return resultvector;
    }

    public int[] constructIndexVector(RowData data, ClusStatistic stat) {
        int nb = (int)stat.getTotalWeight();
        int[] resultvector = new int[nb];
        for (int i = 0; i < nb; ++i) {
            int index;
            resultvector[i] = index = data.getTuple(i).getIndex();
        }
        return resultvector;
    }

    public void generateMatrix(RowData data, Integer[] permutation) throws IOException {
        m_distances.clear();
        ClusSchema schema = data.getSchema();
        int N = data.getNbRows();
        double maxdist = 0.0;
        double d = 0.0;
        double minDistLine = Double.POSITIVE_INFINITY;
        double maxOnMinDistLine = 0.0;
        double[][] w = new double[N][N];
        for (int i = 0; i < N; ++i) {
            minDistLine = Double.POSITIVE_INFINITY;
            for (int j = 0; j < N; ++j) {
                int tupleI = permutation[i];
                int tupleJ = permutation[j];
                DataTuple exi = data.getTuple(tupleI);
                DataTuple exj = data.getTuple(tupleJ);
                NumericAttrType xt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                NumericAttrType yt = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                double xi = ((ClusAttrType)xt).getNumeric(exi);
                double yi = ((ClusAttrType)yt).getNumeric(exi);
                double xj = ((ClusAttrType)xt).getNumeric(exj);
                double yj = ((ClusAttrType)yt).getNumeric(exj);
                Boolean longlat = schema.getSettings().getTree().isLonglat();
                d = longlat == true ? this.LanLongdistance(xi, yi, xj, yj) : Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
                if (d > maxdist) {
                    maxdist = d;
                }
                if (d == 0.0 || !(d < minDistLine)) continue;
                minDistLine = d;
            }
            if (!(minDistLine > maxOnMinDistLine)) continue;
            maxOnMinDistLine = minDistLine;
        }
        double bandwidth = schema.getSettings().getTree().getBandwidth();
        double b = bandwidth * maxdist;
        if (maxOnMinDistLine != Double.POSITIVE_INFINITY && b < maxOnMinDistLine) {
            b = maxOnMinDistLine;
        }
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                int tupleJ;
                int tupleI = permutation[i];
                if (tupleI > (tupleJ = permutation[j].intValue())) {
                    w[tupleI][tupleJ] = w[tupleJ][tupleI];
                    continue;
                }
                DataTuple exi = data.getTuple(tupleI);
                DataTuple exj = data.getTuple(tupleJ);
                NumericAttrType xti = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[0];
                NumericAttrType yti = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.GIS)[1];
                double xii = ((ClusAttrType)xti).getNumeric(exi);
                double yii = ((ClusAttrType)yti).getNumeric(exi);
                double xji = ((ClusAttrType)xti).getNumeric(exj);
                double yji = ((ClusAttrType)yti).getNumeric(exj);
                Boolean longlat = schema.getSettings().getTree().isLonglat();
                d = longlat == true ? this.LanLongdistance(xii, yii, xji, yji) : Math.sqrt((xii - xji) * (xii - xji) + (yii - yji) * (yii - yji));
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                if (d >= b) {
                    w[tupleI][tupleJ] = 0.0;
                    continue;
                }
                if (d == 0.0) {
                    w[tupleI][tupleJ] = 1.0;
                } else {
                    switch (spatialMatrix) {
                        case Binary: {
                            w[tupleI][tupleJ] = 1.0;
                        }
                        case Euclidean: {
                            w[tupleI][tupleJ] = 1.0 - d / b;
                            break;
                        }
                        case Modified: {
                            w[tupleI][tupleJ] = (1.0 - d * d / (b * b)) * (1.0 - d * d / (b * b));
                            break;
                        }
                        case Gaussian: {
                            w[tupleI][tupleJ] = Math.exp(-(d * d) / (b * b));
                            break;
                        }
                        default: {
                            w[tupleI][tupleJ] = 0.0;
                        }
                    }
                }
                m_distances.put(Long.valueOf(tupleI * N + tupleJ), w[tupleI][tupleJ]);
            }
        }
    }

    public void readMatrixFromFile(RowData data) throws IOException {
        m_distancesS.clear();
        m_distancesN.clear();
        ClusSchema schema = data.getSchema();
        double maxdist = 0.0;
        double minDistLine = Double.POSITIVE_INFINITY;
        double maxOnMinDistLine = 0.0;
        double iEqual = Double.POSITIVE_INFINITY;
        String filename = "distances.csv";
        BufferedReader br = new BufferedReader(new FileReader(filename));
        double bandwidth = schema.getSettings().getTree().getBandwidth();
        if (bandwidth != 100.0) {
            Object s;
            while (br.ready()) {
                s = br.readLine();
                StringTokenizer st = new StringTokenizer((String)s, ",");
                Long ii = Long.parseLong(st.nextToken());
                Long jj = Long.parseLong(st.nextToken());
                double d = Double.parseDouble(st.nextToken());
                if (iEqual != (double)ii.longValue()) {
                    m_distancesN.put(ii + "#" + ii, 0.0);
                    iEqual = ii.longValue();
                }
                if (ii > jj) {
                    m_distancesN.put(jj + "#" + ii, d);
                    continue;
                }
                m_distancesN.put(ii + "#" + jj, d);
            }
            s = m_distancesN.values().iterator();
            while (s.hasNext()) {
                double d = (Double)s.next();
                if (d > maxdist) {
                    maxdist = d;
                }
                if (d == 0.0 || !(d < minDistLine)) continue;
                minDistLine = d;
            }
            if (minDistLine > maxOnMinDistLine) {
                maxOnMinDistLine = minDistLine;
            }
            double b = bandwidth * maxdist;
            if (maxOnMinDistLine != Double.POSITIVE_INFINITY && b < maxOnMinDistLine) {
                b = maxOnMinDistLine;
            }
            SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
            for (Map.Entry entry : m_distancesN.entrySet()) {
                double w;
                String i = (String)entry.getKey();
                double d = (Double)entry.getValue();
                if (d >= b) {
                    w = 0.0;
                    continue;
                }
                if (d == 0.0) {
                    w = 1.0;
                } else {
                    switch (spatialMatrix) {
                        case Binary: {
                            w = 0.0;
                            break;
                        }
                        case Euclidean: {
                            w = 1.0 - d / b;
                            break;
                        }
                        case Modified: {
                            w = Math.pow((1.0 - d * d / (b * b)) * (1.0 - d * d / (b * b)), 2.0);
                            break;
                        }
                        case Gaussian: {
                            w = Math.exp(-(d * d) / (b * b));
                            break;
                        }
                        default: {
                            w = 0.0;
                        }
                    }
                }
                m_distancesS.put(i, w);
            }
        } else {
            while (br.ready()) {
                double w;
                String s = br.readLine();
                StringTokenizer st = new StringTokenizer(s, ",");
                String ii = st.nextToken().toLowerCase();
                String jj = st.nextToken().toLowerCase();
                double d = Double.parseDouble(st.nextToken());
                SettingsTree.SpatialMatrixType spatialMatrix = schema.getSettings().getTree().getSpatialMatrix();
                switch (spatialMatrix) {
                    case Binary: {
                        if (d == 1.0) {
                            w = 1.0;
                            break;
                        }
                        w = 0.0;
                        break;
                    }
                    case Euclidean: {
                        if (d == 1.0) {
                            w = 0.01;
                            break;
                        }
                        w = 1.0 - 1.0 / d;
                        break;
                    }
                    default: {
                        w = 0.0;
                    }
                }
                m_distancesS.put(ii + "#" + jj, w);
                m_distancesS.put(jj + "#" + ii, w);
            }
        }
        br.close();
    }

    public double calcI(ClusStatistic t_stat, ClusStatistic p_stat, ClusStatistic missing, Integer[] permutation) throws Exception {
        ClusStatistic pstat = p_stat;
        if (this.stopCriterion(t_stat, p_stat, missing)) {
            return Double.NEGATIVE_INFINITY;
        }
        double ss_pos = 0.0;
        ClusSchema schema = this.m_Data.getSchema();
        SettingsTree.SpatialMeasure sm = schema.getSettings().getTree().getSpatialMeasure();
        if (!this.m_WarningGiven && !sm.equals((Object)SettingsTree.SpatialMeasure.GlobalMoran)) {
            this.m_WarningGiven = true;
            System.err.println("Warning: your spatial measure was not tested. Be careful.");
        }
        switch (sm) {
            case GlobalMoran: {
                ss_pos = pstat.calcItotal(permutation);
                break;
            }
            case GlobalGeary: {
                ss_pos = pstat.calcGtotal(permutation);
                break;
            }
            case GlobalGetis: {
                ss_pos = pstat.calcGetisTotal(permutation);
                break;
            }
            case LocalMoran: {
                ss_pos = pstat.calcLISAtotal(permutation);
                break;
            }
            case LocalGeary: {
                ss_pos = pstat.calcGLocalTotal(permutation);
                break;
            }
            case LocalGetis: {
                ss_pos = pstat.calcLocalGetisTotal(permutation);
                break;
            }
            case StandardizedGetis: {
                ss_pos = pstat.calcGETIStotal(permutation);
                break;
            }
            case EquvalentI: {
                ss_pos = pstat.calcEquvalentItotal(permutation);
                break;
            }
            case IwithNeighbours: {
                ss_pos = pstat.calcIwithNeighbourstotal(permutation);
                break;
            }
            case EquvalentIwithNeighbours: {
                ss_pos = pstat.calcEquvalentIwithNeighbourstotal(permutation);
                break;
            }
            case GlobalMoranDistance: {
                ss_pos = pstat.calcItotalD(permutation);
                break;
            }
            case GlobalGearyDistance: {
                ss_pos = pstat.calcGtotalD(permutation);
                break;
            }
            case CI: {
                ss_pos = pstat.calcCItotal(permutation);
                break;
            }
            case MultiVariateMoranI: {
                ss_pos = pstat.calcMutivariateItotal(permutation);
                break;
            }
            case CwithNeighbours: {
                ss_pos = pstat.calcCwithNeighbourstotal(permutation);
                break;
            }
            case Lee: {
                ss_pos = pstat.calcBivariateLee(permutation);
                break;
            }
            case MultiIwithNeighbours: {
                ss_pos = pstat.calcMultiIwithNeighbours(permutation);
                break;
            }
            case CIwithNeighbours: {
                ss_pos = pstat.calcCIwithNeighbours(permutation);
                break;
            }
            case LeewithNeighbours: {
                ss_pos = pstat.calcLeewithNeighbours(permutation);
                break;
            }
            case Pearson: {
                ss_pos = pstat.calcPtotal(permutation);
                break;
            }
            case CIDistance: {
                ss_pos = pstat.calcCItotalD(permutation);
                break;
            }
            case DH: {
                ss_pos = pstat.calcDHtotalD(permutation);
                break;
            }
            case EquvalentIDistance: {
                ss_pos = pstat.calcEquvalentIDistance(permutation);
                break;
            }
            case PearsonDistance: {
                ss_pos = pstat.calcPDistance(permutation);
                break;
            }
            case EquvalentG: {
                ss_pos = pstat.calcEquvalentGtotal(permutation);
                break;
            }
            case EquvalentGDistance: {
                ss_pos = pstat.calcEquvalentGDistance(permutation);
                break;
            }
            case EquvalentPDistance: {
                ss_pos = pstat.calcEquvalentPDistance(permutation);
            }
        }
        return ss_pos;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double value = 0.0;
        if (c_tstat instanceof ClassificationStat) {
            double neg_ent;
            double pos_ent;
            ClassificationStat tstat = (ClassificationStat)c_tstat;
            ClassificationStat pstat = (ClassificationStat)c_pstat;
            if (this.stopCriterion(c_tstat, c_pstat, missing)) {
                return Double.NEGATIVE_INFINITY;
            }
            double n_tot = tstat.getTotalWeight();
            double n_pos = pstat.getTotalWeight();
            double n_neg = n_tot - n_pos;
            double tot_ent = tstat.entropy();
            value = tot_ent - (n_pos * (pos_ent = pstat.entropy()) + n_neg * (neg_ent = tstat.entropyDifference(pstat))) / n_tot;
            if (value < 1.0E-6) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.m_GainRatio) {
                double si = ClassificationStat.computeSplitInfo(n_tot, n_pos, n_neg);
                if (si < 1.0E-6) {
                    return Double.NEGATIVE_INFINITY;
                }
                value /= si;
            }
        } else if (c_tstat instanceof RegressionStat) {
            RegressionStat tstat = (RegressionStat)c_tstat;
            RegressionStat pstat = (RegressionStat)c_pstat;
            if (this.stopCriterion(c_tstat, c_pstat, missing)) {
                return Double.NEGATIVE_INFINITY;
            }
            double ss_tot = tstat.getSVarS(this.m_ClusteringWeights);
            double ss_pos = pstat.getSVarS(this.m_ClusteringWeights);
            double ss_neg = tstat.getSVarSDiff(this.m_ClusteringWeights, (ClusStatistic)pstat);
            value = FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_pos + ss_neg);
        } else {
            WHTDStatistic tstat = (WHTDStatistic)c_tstat;
            WHTDStatistic pstat = (WHTDStatistic)c_pstat;
            if (this.stopCriterion(c_tstat, c_pstat, missing)) {
                return Double.NEGATIVE_INFINITY;
            }
            double ss_tot = tstat.getSVarS(this.m_ClusteringWeights);
            double ss_pos = pstat.getSVarS(this.m_ClusteringWeights);
            double ss_neg = tstat.getSVarSDiff(this.m_ClusteringWeights, pstat);
            value = FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_pos + ss_neg);
            if (this.getSettings().getGeneral().getVerbose() >= 10) {
                ClusLogger.info("TOT: " + tstat.getDebugString());
                ClusLogger.info("POS: " + pstat.getDebugString());
                ClusLogger.info("-> (" + ss_tot + ", " + ss_pos + ", " + ss_neg + ") " + value);
            }
        }
        return value;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic[] c_pstat, int nbsplit) {
        if (this.stopCriterion(c_tstat, c_pstat, nbsplit)) {
            return Double.NEGATIVE_INFINITY;
        }
        double value = 0.0;
        if (c_tstat instanceof ClassificationStat) {
            ClassificationStat tstat = (ClassificationStat)c_tstat;
            double n_tot = tstat.getTotalWeight();
            value = tstat.entropy();
            for (int i = 0; i < nbsplit; ++i) {
                ClassificationStat pstat = (ClassificationStat)c_pstat[i];
                double n_set = pstat.getTotalWeight();
                value -= n_set / n_tot * pstat.entropy();
            }
            if (value < 1.0E-6) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.m_GainRatio) {
                double si = 0.0;
                for (int i = 0; i < nbsplit; ++i) {
                    double n_set = c_pstat[i].getTotalWeight();
                    if (!(n_set >= 1.0E-6)) continue;
                    double div = n_set / n_tot;
                    si -= div * Math.log(div);
                }
                if ((si /= MathUtil.M_LN2) < 1.0E-6) {
                    return Double.NEGATIVE_INFINITY;
                }
                value /= si;
            }
        } else if (c_tstat instanceof RegressionStat) {
            double ss_sum = 0.0;
            RegressionStat tstat = (RegressionStat)c_tstat;
            RegressionStat[] pstat = (RegressionStat[])c_pstat;
            for (int i = 0; i < nbsplit; ++i) {
                ss_sum += pstat[i].getSVarS(this.m_ClusteringWeights);
            }
            double ss_tot = tstat.getSVarS(this.m_ClusteringWeights);
            value = FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_sum);
        }
        return value;
    }

    public double LanLongdistance(double lat1, double lon1, double lat2, double lon2) {
        double dist;
        if (lat1 == lat2 && lon1 == lon2) {
            dist = 0.0;
        } else {
            double theta = lon1 - lon2;
            dist = Math.sin(this.deg2rad(lat1)) * Math.sin(this.deg2rad(lat2)) + Math.cos(this.deg2rad(lat1)) * Math.cos(this.deg2rad(lat2)) * Math.cos(this.deg2rad(theta));
            dist = this.rad2deg(Math.acos(dist));
            dist = dist * 60.0 * 1.1515 * 1.609344;
        }
        return dist;
    }

    public double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    @Override
    public String getName() {
        return "GISHeuristic";
    }
}

