/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.timeseries;

import java.io.Serializable;
import java.util.StringTokenizer;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class TimeSeries
implements Serializable {
    public static final long serialVersionUID = 1L;
    private double[] m_Values;
    private double m_TSWeight;

    public TimeSeries(String values) {
        values = values.trim();
        values = values.replace("[", "");
        values = values.replace("]", "");
        StringTokenizer st = new StringTokenizer(values, ",");
        this.m_Values = new double[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.m_Values[i++] = Double.parseDouble(st.nextToken());
        }
    }

    public TimeSeries(double[] values) {
        this.m_Values = new double[values.length];
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public TimeSeries(int size) {
        this.m_Values = new double[size];
        for (int i = 0; i < size; ++i) {
            this.m_Values[i] = 0.0;
        }
    }

    public TimeSeries(TimeSeries series) {
        this(series.getValues());
    }

    public int length() {
        if (this.m_Values == null) {
            return 0;
        }
        return this.m_Values.length;
    }

    public double[] getValues() {
        double[] result = new double[this.m_Values.length];
        System.arraycopy(this.m_Values, 0, result, 0, this.m_Values.length);
        return result;
    }

    public double[] getValuesNoCopy() {
        return this.m_Values;
    }

    public double getValue(int index) {
        return this.m_Values[index];
    }

    public void setSize(int size) {
        this.m_Values = new double[size];
    }

    public void resize(int newSize, String method) {
        double[] oldValues = this.getValues();
        int oldSize = this.length();
        double[] values = new double[newSize];
        double precision = 1.0E-8;
        if (method.compareTo("linear") == 0) {
            for (int i = 0; i < newSize; ++i) {
                int tmpOriginal = (int)Math.floor((double)((float)i * ((float)oldSize / (float)newSize)) + precision);
                double w = (float)i * ((float)oldSize / (float)newSize) - (float)tmpOriginal;
                values[i] = Math.abs(w) < precision ? oldValues[tmpOriginal] : oldValues[tmpOriginal] * (1.0 - w) + w * oldValues[tmpOriginal + 1];
            }
        }
    }

    public void rescale(double min, double max) {
        double tmpMin = this.min();
        double tmpMax = this.max();
        if (tmpMax == tmpMin) {
            for (int i = 0; i < this.length(); ++i) {
                this.m_Values[i] = (max - min) / 2.0;
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                this.m_Values[i] = (this.m_Values[i] - tmpMin) / (tmpMax - tmpMin) * (max - min) + min;
            }
        }
    }

    public double min() {
        double r = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.length(); ++i) {
            if (!(r > this.m_Values[i])) continue;
            r = this.m_Values[i];
        }
        return r;
    }

    public double max() {
        double r = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.length(); ++i) {
            if (!(r < this.m_Values[i])) continue;
            r = this.m_Values[i];
        }
        return r;
    }

    public void setValues(double[] values) {
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public void setValue(int index, double value) {
        this.m_Values[index] = value;
    }

    public String toString() {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer a = new StringBuffer("[");
        for (int i = 0; i < this.length() - 1; ++i) {
            a.append(fr.format(this.m_Values[i]));
            a.append(',');
        }
        if (this.length() > 0) {
            a.append(fr.format(this.m_Values[this.length() - 1]));
        }
        a.append(']');
        return a.toString();
    }

    public double geTSWeight() {
        return this.m_TSWeight;
    }

    public void setTSWeight(double weight) {
        this.m_TSWeight = weight;
    }

    public static boolean areEqual(TimeSeries ts1, TimeSeries ts2) {
        if (ts1 == null) {
            return ts2 == null;
        }
        if (ts1.length() != ts2.length()) {
            return false;
        }
        if (!ClusUtil.eq(ts1.geTSWeight(), ts2.geTSWeight(), 1.0E-6)) {
            return false;
        }
        for (int i = 0; i < ts1.length(); ++i) {
            if (ClusUtil.eq(ts1.getValue(i), ts2.getValue(i), 1.0E-6)) continue;
            return false;
        }
        return true;
    }
}

