/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.structuredTypes;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.SetDistance;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.SumPairwiseDistancesStat;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class SetStatistic
extends SumPairwiseDistancesStat {
    public static final long serialVersionUID = 1L;
    protected SetAttrType m_Attr;
    private ArrayList<Set> m_SetStack = new ArrayList();
    public Set m_RepresentativeMean = null;
    public Set m_RepresentativeMedoid = null;
    protected double m_AvgDistances;

    public SetStatistic(Settings sett, SetAttrType attr, ClusDistance dist, SettingsTimeSeries.TimeSeriesPrototypeComplexity efficeny) {
        super(sett, dist, efficeny);
        this.m_Attr = attr;
    }

    @Override
    public ClusStatistic cloneStat() {
        SetStatistic stat = new SetStatistic(this.getSettings(), this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.cloneFrom(this);
        return stat;
    }

    @Override
    public ClusStatistic cloneSimple() {
        SetStatistic stat = new SetStatistic(this.getSettings(), this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.m_RepresentativeMean = new Set(this.m_RepresentativeMean.size());
        stat.m_RepresentativeMedoid = new Set(this.m_RepresentativeMedoid.size());
        return stat;
    }

    @Override
    public void copy(ClusStatistic other) {
        SetStatistic or = (SetStatistic)other;
        super.copy(or);
        this.m_SetStack.clear();
        this.m_SetStack.addAll(or.m_SetStack);
    }

    @Override
    public SetStatistic normalizedCopy() {
        SetStatistic copy = (SetStatistic)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        copy.m_SetStack.add(this.getSetPred());
        copy.m_RepresentativeMean.setValues(this.m_RepresentativeMean.getValues());
        copy.m_RepresentativeMedoid.setValues(this.m_RepresentativeMedoid.getValues());
        return copy;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        SetStatistic or = (SetStatistic)other;
        this.m_SumWeight += weight * or.m_SumWeight;
        Set pred = new Set(or.getSetPred());
        pred.setSetWeight(weight);
        this.m_SetStack.add(pred);
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        super.updateWeighted(tuple, idx);
        Set newSet = new Set((Set)tuple.getObjVal(this.getAttribute().getIndex()));
        newSet.setSetWeight(tuple.getWeight());
        this.m_SetStack.add(newSet);
    }

    public double calcDistance(Set ts1, Set ts2) throws ClusException {
        SetDistance dist = (SetDistance)this.getDistance();
        return dist.calcDistance(ts1, ts2);
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) throws ClusException {
        return this.getSVarS(scale, data);
    }

    @Override
    public double getAbsoluteDistance(DataTuple tuple, ClusAttributeWeights weights) throws ClusException {
        int idx = this.m_Attr.getIndex();
        Set actual = (Set)tuple.getObjVal(0);
        return this.calcDistance(this.m_RepresentativeMean, actual) * weights.getWeight(idx);
    }

    public void initNormalizationWeights(ClusAttributeWeights weights, boolean[] shouldNormalize) {
        int idx = this.m_Attr.getIndex();
        if (shouldNormalize[idx]) {
            double var = this.m_SVarS / this.getTotalWeight();
            double norm = var > 0.0 ? 1.0 / var : 1.0;
            weights.setWeight(this.m_Attr, norm);
        }
    }

    public void calcSumAndSumSqDistances(Set prototype) throws ClusException {
        this.m_AvgDistances = 0.0;
        int count = this.m_SetStack.size();
        for (int i = 0; i < count; ++i) {
            double dist = this.calcDistance(prototype, this.m_SetStack.get(i));
            this.m_AvgDistances += dist;
        }
        this.m_AvgDistances /= (double)count;
    }

    @Override
    public void calcMean() throws ClusException {
        Set t1;
        this.m_RepresentativeMedoid = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_SetStack.size(); ++i) {
            double crDistance = 0.0;
            t1 = this.m_SetStack.get(i);
            for (int j = 0; j < this.m_SetStack.size(); ++j) {
                Set t2 = this.m_SetStack.get(j);
                double dist = this.calcDistance(t1, t2);
                crDistance += dist * t2.getSetWeight();
            }
            if (!(crDistance < minDistance)) continue;
            this.m_RepresentativeMedoid = this.m_SetStack.get(i);
            minDistance = crDistance;
        }
        this.calcSumAndSumSqDistances(this.m_RepresentativeMedoid);
        double sumwi = 0.0;
        for (int j = 0; j < this.m_SetStack.size(); ++j) {
            t1 = this.m_SetStack.get(j);
            sumwi += t1.getSetWeight();
        }
        double diff = Math.abs(this.m_SumWeight - sumwi);
        if (diff > 1.0E-6) {
            System.err.println("Error: Sanity check failed! - " + diff);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.m_SetStack.clear();
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        if (this.m_RepresentativeMean != null) {
            buf.append("Mean: ");
            buf.append(this.m_RepresentativeMean);
            if (info.SHOW_EXAMPLE_COUNT) {
                buf.append(": ");
                buf.append(fr.format(this.m_SumWeight));
            }
            buf.append("; ");
        } else {
            buf.append("Medoid: ");
            buf.append(this.m_RepresentativeMedoid);
            if (info.SHOW_EXAMPLE_COUNT) {
                buf.append(": ");
                buf.append(fr.format(this.m_SumWeight));
                buf.append(", ");
                buf.append(fr.format(this.m_AvgDistances));
            }
            buf.append("; ");
        }
        return buf.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        schema.addAttrType(new SetAttrType(prefix + "-p-Set"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Distance"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Size"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-AvgDist"));
    }

    @Override
    public String getPredictWriterString(DataTuple tuple) throws ClusException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_RepresentativeMedoid.toString());
        double dist = this.calcDistanceToCentroid(tuple);
        buf.append(",");
        buf.append(dist);
        buf.append(",");
        buf.append(this.getTotalWeight());
        buf.append(",");
        buf.append(this.m_AvgDistances);
        return buf.toString();
    }

    public Set getRepresentativeMean() {
        return this.m_RepresentativeMean;
    }

    public Set getRepresentativeMedoid() {
        return this.m_RepresentativeMedoid;
    }

    public Set getSetPred() {
        return this.m_RepresentativeMedoid;
    }

    public SetAttrType getAttribute() {
        return this.m_Attr;
    }
}

