/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence.normalization;

import java.util.Arrays;
import java.util.Map;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Normalization;
import si.ijs.kt.clus.ext.semisupervised.utils.IndiceValuePair;

public class Ranking
implements Normalization {
    int nbTargetAttributes;
    boolean lessIsBetter = true;

    public Ranking(int nbTargetAttributes) {
        this.nbTargetAttributes = nbTargetAttributes;
    }

    @Override
    public void normalize(Map<Integer, double[]> perTargetScores) {
        int i;
        IndiceValuePair[][] indValPairs = new IndiceValuePair[this.nbTargetAttributes][perTargetScores.size()];
        int nbExamples = 0;
        for (Integer key : perTargetScores.keySet()) {
            double[] instancePerTargetScores = perTargetScores.get(key);
            for (i = 0; i < instancePerTargetScores.length; ++i) {
                indValPairs[i][nbExamples] = new IndiceValuePair(key, instancePerTargetScores[i]);
            }
            ++nbExamples;
        }
        for (int i2 = 0; i2 < indValPairs.length; ++i2) {
            Arrays.sort(indValPairs[i2]);
        }
        double maxRank = indValPairs[0].length - 1;
        for (i = 0; i < indValPairs[0].length; ++i) {
            for (int j = 0; j < indValPairs.length; ++j) {
                perTargetScores.get((Object)Integer.valueOf((int)indValPairs[j][i].getIndice()))[j] = this.lessIsBetter ? 1.0 - (double)i / maxRank : (double)i / maxRank;
            }
        }
        indValPairs = null;
    }

    @Override
    public void setIsLessBetter(boolean lessIsBetter) {
        this.lessIsBetter = lessIsBetter;
    }
}

