/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence.normalization;

import java.util.Arrays;
import java.util.Map;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Normalization;

public class MinMaxNormalization
implements Normalization {
    int nbTargetAttributes;
    boolean lessIsBetter = true;

    public MinMaxNormalization(int nbTargetAttributes) {
        this.nbTargetAttributes = nbTargetAttributes;
    }

    @Override
    public void normalize(Map<Integer, double[]> perTargetScores) {
        int j;
        double[] instancePerTargetScores;
        double[] min = new double[this.nbTargetAttributes];
        double[] max = new double[this.nbTargetAttributes];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        for (Integer key : perTargetScores.keySet()) {
            instancePerTargetScores = perTargetScores.get(key);
            for (j = 0; j < instancePerTargetScores.length; ++j) {
                if (instancePerTargetScores[j] > max[j]) {
                    max[j] = instancePerTargetScores[j];
                }
                if (!(instancePerTargetScores[j] < min[j])) continue;
                min[j] = instancePerTargetScores[j];
            }
        }
        for (int j2 = 0; j2 < min.length; ++j2) {
            if (min[j2] != max[j2]) continue;
            min[j2] = min[j2] / 2.0;
        }
        if (this.lessIsBetter) {
            for (Integer key : perTargetScores.keySet()) {
                instancePerTargetScores = perTargetScores.get(key);
                for (j = 0; j < instancePerTargetScores.length; ++j) {
                    instancePerTargetScores[j] = 1.0 - (instancePerTargetScores[j] - min[j]) / (max[j] - min[j]);
                }
            }
        } else {
            for (Integer key : perTargetScores.keySet()) {
                instancePerTargetScores = perTargetScores.get(key);
                for (j = 0; j < instancePerTargetScores.length; ++j) {
                    instancePerTargetScores[j] = (instancePerTargetScores[j] - min[j]) / (max[j] - min[j]);
                }
            }
        }
        min = null;
        max = null;
    }

    @Override
    public void setIsLessBetter(boolean lessIsBetter) {
        this.lessIsBetter = lessIsBetter;
    }
}

