/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.semisupervised.confidence.PredictionConfidence;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class OracleScore
extends PredictionConfidence {
    double m_HmcThreshold = 0.5;

    public OracleScore(ClusStatManager statManager, SettingsSSL.SSLNormalization normalizationType, SettingsSSL.SSLAggregation aggregationType) {
        super(statManager, normalizationType, aggregationType);
    }

    @Override
    public double[] calculatePerTargetScores(ClusModel model, DataTuple tuple) throws ClusException, InterruptedException {
        ClusStatistic stat = model.predictWeighted(tuple);
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY) {
            stat.computePrediction();
            ClassificationStat tempStat = (ClassificationStat)stat.cloneStat();
            ClassificationStat tempStat2 = (ClassificationStat)stat;
            tempStat.reset();
            tempStat.updateWeighted(tuple, tuple.getWeight());
            tempStat.computePrediction();
            double[] distances = new double[this.m_NbTargets];
            for (int i = 0; i < tempStat.m_MajorityClasses.length; ++i) {
                distances[i] = (tempStat.m_MajorityClasses[i] - tempStat2.m_MajorityClasses[i]) * (tempStat.m_MajorityClasses[i] - tempStat2.m_MajorityClasses[i]);
            }
            return distances;
        }
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            ((WHTDStatistic)stat).setThreshold(this.m_HmcThreshold);
            stat.computePrediction();
            DataTuple tempTuple = tuple.deepCloneTuple();
            stat.predictTuple(tempTuple);
            WHTDStatistic tempStat = (WHTDStatistic)stat.cloneStat();
            tempStat.reset();
            tempStat.setThreshold(this.m_HmcThreshold);
            tempStat.updateWeighted(tempTuple, tempTuple.getWeight());
            tempStat.calcMean();
            return tempStat.getPointwiseSquaredDistance(tuple);
        }
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.REGRESSION) {
            stat.computePrediction();
            return ((RegressionStatBase)stat).getPointwiseSquaredDistance(tuple, this.m_StatManager.getNormalizationWeights());
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] calculatePerTargetOOBScores(ClusForest model, DataTuple tuple) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setHmcThreshold(double t) {
        this.m_HmcThreshold = t;
    }
}

