/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised;

import java.util.Arrays;
import si.ijs.kt.clus.ext.semisupervised.utils.DoublesPair;
import si.ijs.kt.clus.ext.semisupervised.utils.IndiceValuePair;
import si.ijs.kt.clus.util.ClusLogger;

public class Helper {
    public static double average(double[] values) {
        double avg = 0.0;
        for (int i = 0; i < values.length; ++i) {
            avg += values[i];
        }
        return avg / (double)values.length;
    }

    public static double averageIgnoreZeros(double[] values) {
        double avg = 0.0;
        int counter = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < -1.0E-9) && !(values[i] > 1.0E-9)) continue;
            ++counter;
            avg += values[i];
        }
        return avg / (double)counter;
    }

    public static double min(double[] values) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double max(double[] values) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public static String arrayToString(double[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = i + 1 < array.length ? ret + array[i] + "," : ret + array[i];
        }
        return ret;
    }

    public static String arrayToString(double[] array, String sep) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = i + 1 < array.length ? ret + array[i] + sep : ret + array[i];
        }
        return ret;
    }

    public static String arrayToString(String[] array, String sep) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = i + 1 < array.length ? ret + array[i] + sep : ret + array[i];
        }
        return ret;
    }

    public static String arrayToString(IndiceValuePair[] array, String sep) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = i + 1 < array.length ? ret + array[i].getIndice() + ":" + array[i].getValue() + sep : ret + array[i].getIndice() + ":" + array[i].getValue();
        }
        return ret;
    }

    public static double stDevOpt(double[] a) {
        double avg = 0.0;
        double summ = 0.0;
        for (int i = 0; i < a.length; ++i) {
            avg += a[i];
            summ += a[i] * a[i];
        }
        double sd = (summ - (double)a.length * (avg /= (double)a.length) * avg) / (double)(a.length - 1);
        return Math.sqrt(sd);
    }

    public static double[] getArrayOfSecond(DoublesPair[] dpArrray) {
        double[] temp = new double[dpArrray.length];
        for (int i = 0; i < dpArrray.length; ++i) {
            temp[i] = dpArrray[i].getSecond();
        }
        return temp;
    }

    public static void printArray(DoublesPair[] array) {
        for (int i = 0; i < array.length; ++i) {
            ClusLogger.info(array[i].getFirst() + "," + array[i].getSecond());
        }
    }

    public static void printArray(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (i + 1 < array.length) {
                System.out.print(array[i] + ",");
                continue;
            }
            System.out.print(array[i]);
        }
    }

    public static double getMean(double[] data) {
        double sum = 0.0;
        for (double a : data) {
            sum += a;
        }
        return sum / (double)data.length;
    }

    public static double getVariance(double[] data) {
        double mean = Helper.getMean(data);
        double temp = 0.0;
        for (double a : data) {
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)(data.length - 1);
    }

    public static double getStdDev(double[] data) {
        return Math.sqrt(Helper.getVariance(data));
    }

    public static double median(double[] data) {
        double[] b = new double[data.length];
        System.arraycopy(data, 0, b, 0, b.length);
        Arrays.sort(b);
        if (data.length % 2 == 0) {
            return (b[b.length / 2 - 1] + b[b.length / 2]) / 2.0;
        }
        return b[b.length / 2];
    }

    public static IndiceValuePair[] leastKelements(double[] myArray, int K) {
        IndiceValuePair[] pairs = new IndiceValuePair[K];
        int added = 0;
        block0: for (int i = 0; i < myArray.length; ++i) {
            for (int j = 0; j < K; ++j) {
                if (pairs[j] == null) {
                    if (Double.isNaN(myArray[i])) continue block0;
                    pairs[j] = new IndiceValuePair(i, myArray[i]);
                    ++added;
                    continue block0;
                }
                if (!(pairs[j].getValue() > myArray[i])) continue;
                for (int k = K - 1; k > j; --k) {
                    pairs[k] = pairs[k - 1];
                }
                if (Double.isNaN(myArray[i])) continue block0;
                pairs[j] = new IndiceValuePair(i, myArray[i]);
                ++added;
                continue block0;
            }
        }
        if (added < K) {
            return Arrays.copyOf(pairs, added);
        }
        return pairs;
    }

    public static IndiceValuePair[] greatestKelements(double[] myArray, int K) {
        IndiceValuePair[] pairs = new IndiceValuePair[K];
        int added = 0;
        block0: for (int i = 0; i < myArray.length; ++i) {
            for (int j = 0; j < K; ++j) {
                if (pairs[j] == null) {
                    if (Double.isNaN(myArray[i])) continue block0;
                    pairs[j] = new IndiceValuePair(i, myArray[i]);
                    ++added;
                    continue block0;
                }
                if (!(pairs[j].getValue() < myArray[i])) continue;
                for (int k = K - 1; k > j; --k) {
                    pairs[k] = pairs[k - 1];
                }
                if (Double.isNaN(myArray[i])) continue block0;
                pairs[j] = new IndiceValuePair(i, myArray[i]);
                ++added;
                continue block0;
            }
        }
        if (added < K) {
            return Arrays.copyOf(pairs, added);
        }
        return pairs;
    }
}

