/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.ClusInductionAlgorithmType;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.ext.semisupervised.ClusSelfTrainingFTFInduce;
import si.ijs.kt.clus.ext.semisupervised.ClusSelfTrainingInduce;
import si.ijs.kt.clus.ext.semisupervised.ClusSemiSupervisedPCTs;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public class ClusSemiSupervisedClassifier
extends ClusInductionAlgorithmType {
    protected ClusInductionAlgorithmType m_clss;

    public ClusSemiSupervisedClassifier(Clus clus, ClusInductionAlgorithmType clss) {
        super(clus);
        this.m_clss = clss;
    }

    @Override
    public ClusInductionAlgorithm createInduce(ClusSchema schema, Settings settx, CMDLineArgs cargs) throws ClusException, IOException {
        SettingsSSL sett = settx.getSSL();
        switch (sett.getSemiSupervisedMethod()) {
            case SelfTraining: {
                return new ClusSelfTrainingInduce(schema, settx, this.m_clss.createInduce(schema, settx, cargs));
            }
            case SelfTrainingFTF: {
                return new ClusSelfTrainingFTFInduce(schema, settx, this.m_clss.createInduce(schema, settx, cargs));
            }
            case PCT: {
                return new ClusSemiSupervisedPCTs(this.m_clss.createInduce(schema, settx, cargs));
            }
        }
        return new ClusSelfTrainingInduce(schema, settx, this.m_clss.createInduce(schema, settx, cargs));
    }

    @Override
    public void pruneAll(ClusRun cr) throws ClusException, IOException, InterruptedException {
        this.m_clss.pruneAll(cr);
    }

    @Override
    public void postProcess(ClusRun cr) throws ClusException, IOException, InterruptedException {
        ClusModelInfo def_info = cr.addModelInfo(0);
        def_info.setModel(ClusDecisionTree.induceDefault(cr));
        this.m_clss.postProcess(cr);
    }

    @Override
    public ClusModel pruneSingle(ClusModel model, ClusRun cr) throws ClusException, IOException {
        return null;
    }

    @Override
    public void printInfo() {
        Settings sett = this.getSettings();
        ClusLogger.info("SSL Method: " + sett.getSSL().getSemiSupervisedMethod().toString());
        ClusLogger.info("Base method:");
        this.m_clss.printInfo();
    }
}

