/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.model.test.SoftTest;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.array.MyIntArray;
import si.ijs.kt.clus.util.jeans.util.sort.DoubleIndexSorter;

public class SoftNumericTest
extends SoftTest {
    public static final long serialVersionUID = 1L;
    protected NumericAttrType m_Type;
    protected double[] m_Bounds;
    protected int[] m_Folds;
    protected int[][] m_BoundFolds;
    protected int[][] m_PosFolds;
    protected int[][] m_NegFolds;

    public SoftNumericTest(NodeTest test, int gsize) {
        NumericTest ntest = (NumericTest)test;
        this.m_Type = ntest.getNumType();
        this.m_Bounds = new double[gsize];
        this.m_Folds = new int[gsize];
        this.setArity(2);
    }

    public String getStringWithPrefix(String prefix) {
        StringBuffer buff = new StringBuffer();
        buff.append(prefix);
        buff.append(" > [");
        for (int i = 0; i < this.m_Bounds.length; ++i) {
            if (i != 0) {
                buff.append("; ");
            }
            buff.append(ClusFormat.FOUR_AFTER_DOT.format(this.m_Bounds[i]));
            buff.append(" ");
            int[] folds = this.m_BoundFolds[i];
            for (int j = 0; j < folds.length; ++j) {
                if (j != 0) {
                    buff.append(",");
                }
                buff.append(folds[j]);
            }
        }
        buff.append("]");
        return buff.toString();
    }

    @Override
    public String getString() {
        return this.getStringWithPrefix(this.m_Type.getName());
    }

    @Override
    public String getPythonString(String xsElement) {
        return this.getStringWithPrefix(xsElement);
    }

    public int foldSetIntersects2(DataTuple data, int[] folds) {
        int[] dfolds = data.m_Folds;
        for (int i = 0; i < folds.length; ++i) {
            if (dfolds[folds[i]] <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int softPredictNb2(DataTuple tuple, int branch) {
        double value = tuple.getDoubleVal(this.m_Type.getArrayIndex());
        if (branch == 0) {
            if (value > this.m_Bounds[0]) {
                return 1;
            }
            if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
                return 0;
            }
            int ps = 1;
            while (value <= this.m_Bounds[ps]) {
                ++ps;
            }
            return this.foldSetIntersects2(tuple, this.m_PosFolds[ps]);
        }
        if (value > this.m_Bounds[0]) {
            return 0;
        }
        if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
            return 1;
        }
        int ps = 1;
        while (value <= this.m_Bounds[ps]) {
            ++ps;
        }
        return this.foldSetIntersects2(tuple, this.m_NegFolds[ps]);
    }

    public int foldSetIntersects(DataTuple data, int[] folds) {
        int fold = data.m_Index;
        if (fold == -1) {
            return MyIntArray.isIntersectSorted(data.m_Folds, folds);
        }
        if (Arrays.binarySearch(folds, fold) >= 0) {
            return folds.length > 1 ? 1 : 0;
        }
        return 1;
    }

    @Override
    public int softPredictNb(DataTuple tuple, int branch) {
        double value = tuple.getDoubleVal(this.m_Type.getArrayIndex());
        if (branch == 0) {
            if (value > this.m_Bounds[0]) {
                return 1;
            }
            if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
                return 0;
            }
            int ps = 1;
            while (value <= this.m_Bounds[ps]) {
                ++ps;
            }
            return this.foldSetIntersects(tuple, this.m_PosFolds[ps]);
        }
        if (value > this.m_Bounds[0]) {
            return 0;
        }
        if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
            return 1;
        }
        int ps = 1;
        while (value <= this.m_Bounds[ps]) {
            ++ps;
        }
        return this.foldSetIntersects(tuple, this.m_NegFolds[ps]);
    }

    public int[] updateFoldSet(DataTuple data, int[] folds) {
        int fold = data.m_Index;
        int[] rfolds = fold == -1 ? MyIntArray.intersectSorted(data.m_Folds, folds) : (Arrays.binarySearch(folds, fold) >= 0 ? MyIntArray.remove(fold, folds) : folds);
        return rfolds;
    }

    public int updateFoldSet(RowData data, int idx, DataTuple tuple, int[] folds) {
        int[] res = this.updateFoldSet(tuple, folds);
        if (res.length > 0) {
            DataTuple clone = tuple.cloneTuple();
            clone.m_Index = -1;
            clone.m_Folds = res;
            data.setTuple(clone, idx++);
        }
        return idx;
    }

    @Override
    public int softPredict(RowData res, DataTuple tuple, int idx, int branch) {
        double value = tuple.getDoubleVal(this.m_Type.getArrayIndex());
        if (branch == 0) {
            if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
                return idx;
            }
            if (value > this.m_Bounds[0]) {
                res.setTuple(tuple, idx++);
                return idx;
            }
            int ps = 1;
            while (value <= this.m_Bounds[ps]) {
                ++ps;
            }
            return this.updateFoldSet(res, idx, tuple, this.m_PosFolds[ps]);
        }
        if (value > this.m_Bounds[0]) {
            return idx;
        }
        if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
            res.setTuple(tuple, idx++);
            return idx;
        }
        int ps = 1;
        while (value <= this.m_Bounds[ps]) {
            ++ps;
        }
        return this.updateFoldSet(res, idx, tuple, this.m_NegFolds[ps]);
    }

    public int updateFoldSet2(RowData data, int idx, DataTuple tuple, int[] folds) {
        if (this.foldSetIntersects2(tuple, folds) != 0) {
            DataTuple clone = tuple.cloneTuple();
            int[] origflds = tuple.m_Folds;
            clone.m_Folds = new int[origflds.length];
            for (int i = 0; i < folds.length; ++i) {
                int ps = folds[i];
                clone.m_Folds[ps] = origflds[ps];
            }
            data.setTuple(clone, idx++);
        }
        return idx;
    }

    @Override
    public int softPredict2(RowData res, DataTuple tuple, int idx, int branch) {
        double value = tuple.getDoubleVal(this.m_Type.getArrayIndex());
        if (branch == 0) {
            if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
                return idx;
            }
            if (value > this.m_Bounds[0]) {
                res.setTuple(tuple, idx++);
                return idx;
            }
            int ps = 1;
            while (value <= this.m_Bounds[ps]) {
                ++ps;
            }
            return this.updateFoldSet2(res, idx, tuple, this.m_PosFolds[ps]);
        }
        if (value > this.m_Bounds[0]) {
            return idx;
        }
        if (value <= this.m_Bounds[this.m_Bounds.length - 1]) {
            res.setTuple(tuple, idx++);
            return idx;
        }
        int ps = 1;
        while (value <= this.m_Bounds[ps]) {
            ++ps;
        }
        return this.updateFoldSet2(res, idx, tuple, this.m_NegFolds[ps]);
    }

    public void addTest(int idx, int fold, NodeTest test) {
        NumericTest ntest = (NumericTest)test;
        this.m_Bounds[idx] = ntest.getBound();
        this.m_Folds[idx] = fold;
    }

    public void sortIntervals() {
        int i;
        DoubleIndexSorter sort = DoubleIndexSorter.getInstance();
        sort.setData(this.m_Bounds, this.m_Folds);
        sort.sort();
        int nb = 0;
        double prev = Double.NaN;
        for (int i2 = 0; i2 < this.m_Bounds.length; ++i2) {
            if (this.m_Bounds[i2] == prev) continue;
            ++nb;
            prev = this.m_Bounds[i2];
        }
        double[] old = this.m_Bounds;
        this.m_Bounds = new double[nb];
        this.m_BoundFolds = new int[nb][];
        int idx = 0;
        prev = old[0];
        int nb_folds = 0;
        for (int i3 = 0; i3 <= old.length; ++i3) {
            if (i3 == old.length || old[i3] != prev) {
                if (nb_folds > 0) {
                    this.m_BoundFolds[idx] = new int[nb_folds];
                    int[] folds = this.m_BoundFolds[idx];
                    for (int j = 0; j < nb_folds; ++j) {
                        folds[j] = this.m_Folds[i3 - j - 1];
                    }
                    Arrays.sort(folds);
                    nb_folds = 0;
                }
                this.m_Bounds[idx++] = prev;
                if (i3 < old.length) {
                    prev = old[i3];
                }
            }
            ++nb_folds;
        }
        this.m_Folds = null;
        this.m_PosFolds = new int[nb][];
        this.m_NegFolds = new int[nb][];
        int[] nArray = this.m_BoundFolds[nb - 1];
        this.m_PosFolds[nb - 1] = nArray;
        int[] prev_v = nArray;
        for (i = nb - 2; i > 0; --i) {
            this.m_PosFolds[i] = MyIntArray.mergeSorted(prev_v, this.m_BoundFolds[i]);
            prev_v = this.m_PosFolds[i];
        }
        this.m_NegFolds[1] = this.m_BoundFolds[0];
        prev_v = this.m_NegFolds[1];
        for (i = 2; i < nb; ++i) {
            this.m_NegFolds[i] = MyIntArray.mergeSorted(prev_v, this.m_BoundFolds[i - 1]);
            prev_v = this.m_NegFolds[i];
        }
    }

    @Override
    public ClusAttrType getType() {
        return this.m_Type;
    }

    @Override
    public void setType(ClusAttrType type) {
        this.m_Type = (NumericAttrType)type;
    }
}

