/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.optxval.OptXValSplit;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.tree.MyNode;
import si.ijs.kt.clus.util.jeans.util.array.MyIntArray;

public class OptXValNode
extends MyNode {
    public static final long serialVersionUID = 1L;
    protected int[] m_Folds;
    protected ClusNode[] m_Nodes;
    public long m_Time;

    public void init(int[] folds) {
        int mnb = folds.length;
        this.m_Nodes = new ClusNode[mnb];
        this.m_Folds = new int[mnb];
        System.arraycopy(folds, 0, this.m_Folds, 0, mnb);
    }

    public void oneFold(int fold, ClusNode onode) {
    }

    public ClusNode[] getNodes() {
        return this.m_Nodes;
    }

    public final void printTree(PrintWriter writer, String prefix) {
        int nb;
        int lvc = 0;
        for (int i = 0; i < this.m_Folds.length; ++i) {
            ClusNode node = this.m_Nodes[i];
            if (node.hasBestTest()) continue;
            if (lvc != 0) {
                writer.print(", ");
            }
            writer.print(this.m_Folds[i] + ": ");
            writer.print(ClusFormat.ONE_AFTER_DOT.format(node.getTotWeight()));
            ++lvc;
        }
        if (lvc > 0) {
            writer.print(" ");
            OptXValNode.showPath(this.getPath(), writer);
        }
        if ((nb = this.getNbChildren()) > 0) {
            if (lvc > 0) {
                writer.println();
                writer.print(prefix);
            }
        } else {
            writer.println();
        }
        for (int i = 0; i < nb; ++i) {
            OptXValSplit split = (OptXValSplit)this.getChild(i);
            if (i != 0) {
                writer.println(prefix + "|  ");
                writer.print(prefix);
            }
            writer.print("G" + i + " ");
            writer.print(MyIntArray.print(split.getFolds()));
            writer.print(" - ");
            writer.print(split.getTest().getString());
            writer.println();
            int mb = split.getNbChildren();
            String gfix = i != nb - 1 ? "|  " : "   ";
            for (int j = 0; j < mb; ++j) {
                String suffix;
                OptXValNode node = (OptXValNode)split.getChild(j);
                String string = suffix = j != mb - 1 ? "|      " : "       ";
                if (j == 0) {
                    writer.print(prefix + gfix + "+-yes: ");
                } else {
                    writer.println(prefix + gfix + "|");
                    writer.print(prefix + gfix + "+-no:  ");
                }
                node.printTree(writer, prefix + gfix + suffix);
            }
        }
        writer.flush();
    }

    public final ClusNode getTree(int fold) {
        int idx = Arrays.binarySearch(this.m_Folds, fold);
        ClusNode node = this.m_Nodes[idx];
        if (node.hasBestTest() && node.atBottomLevel()) {
            OptXValSplit split = null;
            int nb = this.getNbChildren();
            for (int i = 0; i < nb; ++i) {
                OptXValSplit msplit = (OptXValSplit)this.getChild(i);
                if (!msplit.contains(fold)) continue;
                split = msplit;
                break;
            }
            int arity = node.updateArity();
            for (int i = 0; i < arity; ++i) {
                OptXValNode subnode = (OptXValNode)split.getChild(i);
                node.setChild(subnode.getTree(fold), i);
            }
        }
        return node;
    }

    public final void setNodeIndex(int idx, ClusNode node) {
        this.m_Nodes[idx] = node;
    }

    public final void setNode(int fold, ClusNode node) {
        int idx = Arrays.binarySearch(this.m_Folds, fold);
        this.m_Nodes[idx] = node;
    }
}

