/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.test.InverseNumericTest;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class TestAndHeuristic {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_NUMERIC = 0;
    public static final int TYPE_TEST = 1;
    public static final int TYPE_INVERSE_NUMERIC = 2;
    public ClusStatistic m_TotStat;
    public ClusStatistic m_TotCorrStat;
    public ClusStatistic m_MissingStat;
    public ClusStatistic m_PosStat;
    public ClusStatistic[] m_TestStat;
    public ClusHeuristic m_Heuristic;
    public ClusAttributeWeights m_ClusteringWeights;
    public NodeTest m_Test;
    public int m_TestType;
    public double m_BestHeur;
    public double m_UnknownFreq;
    public ClusAttrType m_SplitAttr;
    public boolean m_IsAcceptable = true;
    public double m_Split;
    public double m_PosFreq;
    public RowData m_Subset;
    private Settings m_Sett;

    public TestAndHeuristic(Settings sett) {
        this.m_Sett = sett;
    }

    public String toString() {
        return this.m_PosStat.getString2();
    }

    public final boolean hasBestTest() {
        return this.m_IsAcceptable && this.m_TestType != -1;
    }

    public final String getTestString() {
        return this.m_Test.getString();
    }

    public final NodeTest updateTest() {
        if (this.m_TestType == 0) {
            this.m_TestType = 1;
            this.m_Test = new NumericTest(this.m_SplitAttr.getType(), this.m_Split, this.m_PosFreq);
        } else if (this.m_TestType == 2) {
            this.m_TestType = 1;
            this.m_Test = new InverseNumericTest(this.m_SplitAttr.getType(), this.m_Split, this.m_PosFreq);
        }
        if (this.m_Test == null) {
            ClusLogger.info("Best test is null");
        }
        this.m_Test.preprocess(1);
        this.m_Test.setUnknownFreq(this.m_UnknownFreq);
        this.m_Test.setHeuristicValue(this.m_BestHeur);
        return this.m_Test;
    }

    public void setInitialData(ClusStatistic totstat, RowData data) throws ClusException {
        this.m_Heuristic.setInitialData(totstat, data);
    }

    public final void initTestSelector(ClusStatistic totstat, RowData subset) {
        this.initTestSelector(totstat);
        for (int i = 0; i < this.m_TestStat.length; ++i) {
            this.m_TestStat[i].setSDataSize(subset.getNbRows());
        }
        this.m_Heuristic.setData(subset);
        this.m_Subset = subset;
    }

    public final void initTestSelector(ClusStatistic totstat) {
        this.m_TotStat = totstat;
        this.resetBestTest();
    }

    public final void resetBestTest() {
        this.m_Test = null;
        this.m_TestType = -1;
        this.m_BestHeur = Double.NEGATIVE_INFINITY;
        this.m_UnknownFreq = 0.0;
    }

    public final void setBestHeur(double value) {
        this.m_BestHeur = value;
    }

    public final void reset(int nb) {
        for (int i = 0; i < nb; ++i) {
            this.m_TestStat[i].reset();
        }
        this.m_MissingStat = this.m_TestStat[nb - 1];
    }

    public final void reset() {
        this.m_PosStat.reset();
    }

    public CurrentBestTestAndHeuristic makeCurrentBesTestAndHeuristic() {
        CurrentBestTestAndHeuristic node = new CurrentBestTestAndHeuristic(this.m_Sett);
        node.m_TotStat = this.m_TotStat;
        node.m_TotCorrStat = this.m_TotCorrStat;
        node.m_MissingStat = this.m_MissingStat;
        node.m_PosStat = this.m_PosStat;
        node.m_TestStat = this.m_TestStat;
        node.m_Heuristic = this.m_Heuristic;
        node.m_ClusteringWeights = this.m_ClusteringWeights;
        node.m_BestTest = this.m_Test;
        node.m_TestType = this.m_TestType;
        node.m_BestHeur = this.m_BestHeur;
        node.m_UnknownFreq = this.m_UnknownFreq;
        node.m_SplitAttr = this.m_SplitAttr;
        node.m_IsAcceptable = this.m_IsAcceptable;
        node.m_BestSplit = this.m_Split;
        node.m_PosFreq = this.m_PosFreq;
        return node;
    }

    public void loadCurrentBesTestAndHeuristic(CurrentBestTestAndHeuristic node) {
        this.m_TotStat = node.m_TotStat;
        this.m_TotCorrStat = node.m_TotCorrStat;
        this.m_MissingStat = node.m_MissingStat;
        this.m_PosStat = node.m_PosStat;
        this.m_TestStat = node.m_TestStat;
        this.m_Heuristic = node.m_Heuristic;
        this.m_ClusteringWeights = node.m_ClusteringWeights;
        this.m_Test = node.m_BestTest;
        this.m_TestType = node.m_TestType;
        this.m_BestHeur = node.m_BestHeur;
        this.m_UnknownFreq = node.m_UnknownFreq;
        this.m_SplitAttr = node.m_SplitAttr;
        this.m_IsAcceptable = node.m_IsAcceptable;
        this.m_Split = node.m_BestSplit;
        this.m_PosFreq = node.m_PosFreq;
    }

    public final void create(ClusStatManager smanager, int nbstat) throws ClusException {
        this.m_TotStat = null;
        this.m_Heuristic = smanager.getHeuristic();
        this.m_TestStat = new ClusStatistic[nbstat];
        for (int i = 0; i < nbstat; ++i) {
            this.m_TestStat[i] = smanager.createClusteringStat();
        }
        this.m_ClusteringWeights = smanager.getClusteringWeights();
        this.m_TotCorrStat = smanager.createClusteringStat();
        this.m_PosStat = this.m_TestStat[0];
    }

    public final void setHeuristic(ClusHeuristic heur) {
        this.m_Heuristic = heur;
    }

    public final double getPosWeight() {
        return this.m_PosStat.getTotalWeight();
    }

    public final double getTotWeight() {
        return this.m_TotStat.getTotalWeight();
    }

    public final double getTotNoUnkW() {
        return this.m_TotCorrStat.getTotalWeight();
    }

    public final void subtractMissing() {
        this.m_TotCorrStat.subtractFromThis(this.m_MissingStat);
    }

    public final void copyTotal() {
        this.m_TotCorrStat.copy(this.m_TotStat);
    }

    public final void calcPosFreq() {
        this.m_PosFreq = this.m_PosStat.getTotalWeight() / this.m_TotStat.getTotalWeight();
    }

    public final ClusStatistic getStat(int i) {
        return this.m_TestStat[i];
    }

    public final ClusStatistic getPosStat() {
        return this.m_PosStat;
    }

    public final ClusStatistic getMissStat() {
        return this.m_MissingStat;
    }

    public final ClusStatistic getTotStat() {
        return this.m_TotStat;
    }

    public double getSplitValue() {
        return this.m_Split;
    }

    public final boolean stopCrit() {
        return false;
    }

    public final void updateNumeric(double val, ClusStatistic pos, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, pos, this.m_MissingStat);
        if (heur > this.m_BestHeur + 1.0E-6) {
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = pos.getTotalWeight() / tot_no_unk;
            this.m_Split = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final void updateNumeric(double val, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= 2) {
            System.err.println("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur - 1.0E-6 > this.m_BestHeur) {
            if (this.m_Sett.getGeneral().getVerbose() >= 2) {
                System.err.println("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            if (this.m_Sett.getGeneral().getVerbose() >= 2) {
                System.err.println(" tot_w: " + tot_w + " tot_no_unk: " + tot_no_unk);
            }
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_Split = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final void updateInverseNumeric(double val, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= 2) {
            System.err.println("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur > this.m_BestHeur + 1.0E-6) {
            if (this.m_Sett.getGeneral().getVerbose() >= 2) {
                System.err.println("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 2;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_Split = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final double calcHeuristic(ClusStatistic stat) throws ClusException {
        return this.m_Heuristic.calcHeuristic(this.m_TotStat, stat, this.m_MissingStat);
    }

    public final double calcHeuristic(ClusStatistic tot, ClusStatistic pos) throws ClusException {
        return this.m_Heuristic.calcHeuristic(tot, pos, this.m_MissingStat);
    }

    public final double calcHeuristic(ClusStatistic tot, ClusStatistic[] set, int arity) {
        return this.m_Heuristic.calcHeuristic(tot, set, arity);
    }

    public final ClusHeuristic getHeuristic() {
        return this.m_Heuristic;
    }

    public final double getHeuristicValue() {
        return this.m_BestHeur;
    }

    public void checkAcceptable(ClusStatistic tot, ClusStatistic pos) {
        this.m_IsAcceptable = this.m_Heuristic.isAcceptable(tot, pos, this.m_MissingStat);
    }

    public final void setRootStatistic(ClusStatistic stat) {
        this.m_Heuristic.setRootStatistic(stat);
        for (int i = 0; i < this.m_TestStat.length; ++i) {
            this.m_TestStat[i].setTrainingStat(stat);
        }
        this.m_TotCorrStat.setTrainingStat(stat);
    }

    public final void statOnData(RowData data) {
        this.setSDataSize(data.getNbRows());
        this.m_Heuristic.setData(data);
    }

    private final void setSDataSize(int nbex) {
        this.m_TotStat.setSDataSize(nbex);
        int nbstat = this.m_TestStat.length;
        for (int i = 0; i < nbstat; ++i) {
            this.m_TestStat[i].setSDataSize(nbex);
        }
    }

    public void setAttribtue(ClusAttrType at) {
        this.m_SplitAttr = at;
    }
}

