/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import java.io.PrintWriter;
import java.io.Serializable;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.optiontree.ClusOptionNode;
import si.ijs.kt.clus.ext.optiontree.ClusSplitNode;
import si.ijs.kt.clus.ext.optiontree.Node;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public abstract class MyNode
implements Node,
Serializable,
ClusModel {
    public static final long serialVersionUID = 1L;
    protected MyArray m_Children = new MyArray();
    protected MyNode m_Parent;
    public ClusStatistic m_ClusteringStat;
    public ClusStatistic m_TargetStat;
    public ClusStatManager m_StatManager;

    public MyNode() {
    }

    public MyNode(MyNode parent) {
        this.m_Parent = parent;
    }

    public final MyNode getRoot() {
        if (this.m_Parent == null) {
            return this;
        }
        return this.m_Parent.getRoot();
    }

    public final int indexOf(MyNode child) {
        for (int i = 0; i < this.getNbChildren(); ++i) {
            if (child != this.getChild(i)) continue;
            return i;
        }
        return -1;
    }

    public final ClusStatistic getClusteringStat() {
        return this.m_ClusteringStat;
    }

    public final ClusStatistic getTargetStat() {
        return this.m_TargetStat;
    }

    public final void setStatManager(ClusStatManager smgr) {
        this.m_StatManager = smgr;
    }

    public final void initTargetStat(ClusStatManager smgr, RowData subset) throws ClusException {
        this.m_TargetStat = smgr.createTargetStat();
        subset.calcTotalStatBitVector(this.m_TargetStat);
    }

    public final void initClusteringStat(ClusStatManager smgr, RowData subset) throws ClusException {
        this.m_ClusteringStat = smgr.createClusteringStat();
        subset.calcTotalStatBitVector(this.m_ClusteringStat);
    }

    public final void initTargetStat(ClusStatManager smgr, ClusStatistic train, RowData subset) throws ClusException {
        this.m_TargetStat = smgr.createTargetStat();
        this.m_TargetStat.setTrainingStat(train);
        subset.calcTotalStatBitVector(this.m_TargetStat);
    }

    public final void initClusteringStat(ClusStatManager smgr, ClusStatistic train, RowData subset) throws ClusException {
        this.m_ClusteringStat = smgr.createClusteringStat();
        this.m_ClusteringStat.setTrainingStat(train);
        subset.calcTotalStatBitVector(this.m_ClusteringStat);
    }

    public abstract MyNode cloneNode();

    public final void addChild(MyNode node) {
        node.setParent(this);
        this.m_Children.addElement(node);
    }

    public final void setChild(MyNode node, int idx) {
        node.setParent(this);
        this.m_Children.setElementAt(node, idx);
    }

    public final void removeChild(MyNode node) {
        node.setParent(null);
        this.m_Children.removeElement(node);
    }

    public final void removeChild(int idx) {
        MyNode child = this.getChild(idx);
        if (child != null) {
            child.setParent(null);
        }
        this.m_Children.removeElementAt(idx);
    }

    public final void removeAllChildren() {
        int nb = this.getNbChildren();
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            node.setParent(null);
        }
        this.m_Children.removeAllElements();
    }

    @Override
    public final MyNode getParent() {
        return this.m_Parent;
    }

    public final void setParent(MyNode parent) {
        this.m_Parent = parent;
    }

    @Override
    public final MyNode getChild(int idx) {
        return (MyNode)this.m_Children.elementAt(idx);
    }

    public final int getChildIndex(MyNode node) {
        for (int i = 0; i < this.getNbChildren(); ++i) {
            if (!this.m_Children.elementAt(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    public final void setChild(int idx, MyNode node) {
        node.setParent(this);
        this.m_Children.setElementAt(node, idx);
    }

    @Override
    public final int getNbChildren() {
        return this.m_Children.size();
    }

    public final void setNbChildren(int nb) {
        this.m_Children.setSize(nb);
    }

    @Override
    public final boolean atTopLevel() {
        return this.m_Parent == null;
    }

    @Override
    public final boolean atBottomLevel() {
        return this.m_Children.size() == 0;
    }

    public final MyNode cloneTree() {
        MyNode clone = this.cloneNode();
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            MyNode node = this.getChild(i);
            clone.setChild(node.cloneTree(), i);
        }
        return clone;
    }

    public final MyNode cloneTree(MyNode n1, MyNode n2) {
        if (n1 == this) {
            return n2;
        }
        MyNode clone = this.cloneNode();
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            MyNode node = this.getChild(i);
            clone.setChild(node.cloneTree(n1, n2), i);
        }
        return clone;
    }

    public final void setClusteringStat(ClusStatistic stat) {
        this.m_ClusteringStat = stat;
    }

    public final void setTargetStat(ClusStatistic stat) {
        this.m_TargetStat = stat;
    }

    public void printTree(PrintWriter writer, StatisticPrintInfo info, String string, RowData examples) {
    }

    public void printTreeInDatabase(PrintWriter writer, String[] tabitem, int[] tabexist, int cpt, String typetree) {
    }

    @Override
    public int getNbNodes() {
        int count = 1;
        int nb = this.getNbChildren();
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            count += node.getNbNodes();
        }
        return count;
    }

    @Override
    public int getNbLeaves() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 1;
        }
        int count = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            count += node.getNbLeaves();
        }
        return count;
    }

    public int getNbOptionNodes() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            count += node.getNbOptionNodes();
        }
        return count + (this instanceof ClusOptionNode ? 1 : 0);
    }

    public int getNbOptions() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            count += node.getNbOptions();
        }
        return count + (this instanceof ClusOptionNode ? this.getNbChildren() : 0);
    }

    public int getNbTrees() {
        int count;
        block4: {
            int nb;
            block3: {
                nb = this.getNbChildren();
                if (nb == 0) {
                    return 1;
                }
                count = 0;
                if (!(this instanceof ClusSplitNode)) break block3;
                count = 1;
                for (int i = 0; i < nb; ++i) {
                    MyNode node = this.getChild(i);
                    count *= node.getNbTrees();
                }
                break block4;
            }
            if (!(this instanceof ClusOptionNode)) break block4;
            for (int i = 0; i < nb; ++i) {
                MyNode node = this.getChild(i);
                count += node.getNbTrees();
            }
        }
        return count;
    }

    @Override
    public String getModelInfo() {
        return "Nodes = " + this.getNbNodes() + " (Leaves: " + this.getNbLeaves() + ", OptionNodes: " + this.getNbOptionNodes() + ", EmbededTrees: " + this.getNbTrees() + ")";
    }
}

