/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.split.SubsetSplit;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.RowDataSortHelper;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.optiontree.TestAndHeuristic;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;

public class FindBestTests {
    public ArrayList<TestAndHeuristic> m_Tests;
    protected RowDataSortHelper m_SortHelper = new RowDataSortHelper();
    protected ClusStatManager m_StatManager;
    protected int m_MaxStats;
    protected int m_MaxSplits;

    public FindBestTests(ClusStatManager mgr) {
        this.m_StatManager = mgr;
        this.m_MaxStats = this.getSchema().getMaxNbStats();
        this.m_Tests = new ArrayList();
    }

    public FindBestTests(ClusStatManager mgr, NominalSplit split) {
        this.m_StatManager = mgr;
        this.m_MaxStats = this.getSchema().getMaxNbStats();
    }

    public ClusSchema getSchema() {
        return this.getStatManager().getSchema();
    }

    public ClusStatManager getStatManager() {
        return this.m_StatManager;
    }

    public RowDataSortHelper getSortHelper() {
        return this.m_SortHelper;
    }

    public Settings getSettings() {
        return this.getStatManager().getSettings();
    }

    public void addBestNominalTest(NominalAttrType at, RowData data, ClusStatistic totstat, ClusRandomNonstatic rnd) throws ClusException {
        int j;
        RowData sample = this.createSample(data, rnd);
        int nbvalues = at.getNbValues();
        SubsetSplit split = new SubsetSplit();
        split.initialize(this.m_StatManager);
        TestAndHeuristic tnh = new TestAndHeuristic(this.getSettings());
        tnh.create(this.m_StatManager, this.m_MaxStats);
        tnh.initTestSelector(totstat, data);
        tnh.setInitialData(totstat, data);
        tnh.setAttribtue(at);
        tnh.resetBestTest();
        int nb_rows = sample.getNbRows();
        if (nbvalues == 2 && !at.hasMissing()) {
            for (j = 0; j < nb_rows; ++j) {
                DataTuple tuple = sample.getTuple(j);
                int value = at.getNominal(tuple);
                if (value != 0) continue;
                tnh.m_TestStat[0].updateWeighted(tuple, j);
            }
            tnh.m_TestStat[1].copy(tnh.m_TotStat);
            tnh.m_TestStat[1].subtractFromThis(tnh.m_TestStat[0]);
        } else {
            for (j = 0; j < nb_rows; ++j) {
                DataTuple tuple = sample.getTuple(j);
                int value = at.getNominal(tuple);
                tnh.m_TestStat[value].updateWeighted(tuple, j);
            }
        }
        CurrentBestTestAndHeuristic curr = tnh.makeCurrentBesTestAndHeuristic();
        split.findSplit(curr, at);
        tnh.loadCurrentBesTestAndHeuristic(curr);
        this.m_Tests.add(tnh);
    }

    public void addBestNumericTest(ClusAttrType at, RowData data, ClusStatistic totstat, ClusRandomNonstatic rnd) throws ClusException {
        DataTuple tuple;
        RowData sample = this.createSample(data, rnd);
        TestAndHeuristic tnh = new TestAndHeuristic(this.getSettings());
        tnh.create(this.m_StatManager, this.m_MaxStats);
        tnh.initTestSelector(totstat, data);
        tnh.setInitialData(totstat, data);
        tnh.setAttribtue(at);
        tnh.resetBestTest();
        if (at.isSparse()) {
            sample.sortSparse((NumericAttrType)at, this.m_SortHelper);
        } else {
            sample.sort((NumericAttrType)at);
        }
        tnh.reset(2);
        int nb_rows = sample.getNbRows();
        tnh.copyTotal();
        if (at.hasMissing()) {
            for (int first = 0; first < nb_rows && at.isMissing(tuple = sample.getTuple(first)); ++first) {
                tnh.m_MissingStat.updateWeighted(tuple, first);
            }
            tnh.subtractMissing();
        }
        double prev = Double.NaN;
        for (int j = first; j < nb_rows; ++j) {
            tuple = sample.getTuple(j);
            double value = at.getNumeric(tuple);
            if (value != prev) {
                if (!Double.isNaN(value)) {
                    tnh.updateNumeric(value, at);
                }
                prev = value;
            }
            tnh.m_PosStat.updateWeighted(tuple, j);
        }
        this.m_Tests.add(tnh);
    }

    public void initSelectorAndSplit(ClusStatistic totstat) throws ClusException {
        for (int i = 0; i < this.m_Tests.size(); ++i) {
            this.m_Tests.get(i).create(this.m_StatManager, this.m_MaxStats);
            this.m_Tests.get(i).setRootStatistic(totstat);
        }
    }

    public boolean initSelectorAndStopCrit(ClusStatistic total, RowData data) {
        for (int i = 0; i < this.m_Tests.size(); ++i) {
            this.m_Tests.get(i).initTestSelector(total, data);
        }
        return false;
    }

    public void setInitialData(ClusStatistic total, RowData data) throws ClusException {
        for (int i = 0; i < this.m_Tests.size(); ++i) {
            this.m_Tests.get(i).setInitialData(total, data);
        }
    }

    private RowData createSample(RowData original, ClusRandomNonstatic rnd) {
        int N = this.getSettings().getTree().getTreeSplitSampling();
        if (N == 0) {
            return original.sample(N, rnd);
        }
        String message = String.format("The value of SplitSampling = %d will result in wrong results.\nUse SplitSampling = 0 or correct the code.", N);
        throw new RuntimeException(message);
    }

    public void sort() {
        Collections.sort(this.m_Tests, new HeuristicComparator());
    }

    public ArrayList<TestAndHeuristic> getBestTests(int n) {
        return new ArrayList<TestAndHeuristic>(this.m_Tests.subList(0, Math.min(n, this.m_Tests.size())));
    }

    public TestAndHeuristic getBestTest() {
        if (this.m_Tests.isEmpty()) {
            return null;
        }
        TestAndHeuristic cur = this.m_Tests.get(0);
        double m = cur.m_BestHeur;
        for (int i = 1; i < this.m_Tests.size(); ++i) {
            if (!(this.m_Tests.get((int)i).m_BestHeur > m)) continue;
            cur = this.m_Tests.get(i);
            m = cur.m_BestHeur;
        }
        return cur;
    }

    public int getNbCandidates() {
        double bestValue = this.m_Tests.get(0).getHeuristicValue();
        if (bestValue == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        int n = 1;
        for (int i = 1; i < this.m_Tests.size(); ++i) {
            if (!(this.m_Tests.get(i).getHeuristicValue() / bestValue > 1.0 - this.getSettings().getOptionTree().getOptionEpsilon())) continue;
            ++n;
        }
        return n;
    }

    public boolean selectMultiple() {
        return this.getNbCandidates() > 1;
    }

    public void printCandidates() {
        for (TestAndHeuristic tnh : this.m_Tests) {
            System.out.print("Attribute: ");
            System.out.print(tnh.m_SplitAttr);
            System.out.print(" heuristic: ");
            System.out.print(tnh.m_BestHeur);
            System.out.print(" split: ");
            ClusLogger.info(tnh.m_Split);
        }
    }

    public void reset() {
    }

    public class HeuristicComparator
    implements Comparator<TestAndHeuristic> {
        @Override
        public int compare(TestAndHeuristic o1, TestAndHeuristic o2) {
            if (o1.getHeuristicValue() == o2.getHeuristicValue()) {
                return 0;
            }
            if (o1.getHeuristicValue() < o2.getHeuristicValue()) {
                return 1;
            }
            return -1;
        }
    }
}

