/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.optiontree.ClusOptionNode;
import si.ijs.kt.clus.ext.optiontree.ClusSplitNode;
import si.ijs.kt.clus.ext.optiontree.FindBestTests;
import si.ijs.kt.clus.ext.optiontree.MyNode;
import si.ijs.kt.clus.ext.optiontree.TestAndHeuristic;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsGeneric;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;

public class DepthFirstInduceWithOptions
extends ClusInductionAlgorithm {
    public MyNode m_Root;
    public FindBestTests m_FindBestTests;

    private DepthFirstInduceWithOptions(ClusInductionAlgorithm other) {
        super(other);
    }

    @Override
    public void initialize() throws ClusException, IOException {
        super.initialize();
    }

    public DepthFirstInduceWithOptions(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws ClusException, IOException, InterruptedException {
        return this.induceSingleUnpruned((RowData)cr.getTrainingSet());
    }

    private void makeLeaf(MyNode node) {
        node.makeLeaf();
        if (this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoClusteringStats)) {
            node.setClusteringStat(null);
        }
    }

    private void induce(ClusSplitNode node, RowData data) throws ClusException {
        int i;
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
            return;
        }
        ClusRandomNonstatic rnd = new ClusRandomNonstatic(this.getSettings().getGeneral().getRandomSeed());
        this.m_FindBestTests = new FindBestTests(this.m_StatManager);
        this.initSelectorAndSplit(this.m_Root.getClusteringStat());
        this.setInitialData(this.m_Root.getClusteringStat(), data);
        ClusAttrType[] attrs = this.getDescriptiveAttributes();
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            ClusAttrType at = attrs[i2];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTests.addBestNominalTest((NominalAttrType)at, data, node.getClusteringStat(), rnd);
                continue;
            }
            if (!(at instanceof NumericAttrType)) continue;
            this.m_FindBestTests.addBestNumericTest(at, data, node.getClusteringStat(), rnd);
        }
        this.m_FindBestTests.sort();
        ArrayList<TestAndHeuristic> candidates = new ArrayList<TestAndHeuristic>();
        TestAndHeuristic bestTest = null;
        bestTest = this.m_FindBestTests.getBestTest();
        if (bestTest != null && bestTest.getHeuristicValue() != Double.NEGATIVE_INFINITY) {
            candidates.add(bestTest);
            ArrayList<TestAndHeuristic> bestTests = this.m_FindBestTests.getBestTests(this.getSettings().getOptionTree().getOptionMaxNumberOfOptionsPerNode());
            if (node.getLevel() < this.getSettings().getOptionTree().getOptionMaxDepthOfOptionNode()) {
                for (i = 1; i < bestTests.size(); ++i) {
                    TestAndHeuristic currentTest = bestTests.get(i);
                    if (!(currentTest.getHeuristicValue() / bestTest.getHeuristicValue() >= 1.0 - this.getSettings().getOptionTree().getOptionEpsilon() * Math.pow(this.getSettings().getOptionTree().getOptionDecayFactor(), node.getLevel()))) continue;
                    candidates.add(currentTest);
                }
            }
        }
        if (candidates.size() == 0) {
            this.makeLeaf(node);
            return;
        }
        if (candidates.size() == 1) {
            int j;
            TestAndHeuristic best = this.m_FindBestTests.getBestTest();
            node.testToNode(best);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Test: " + node.getTestString() + " -> " + best.getHeuristicValue());
            }
            int arity = node.updateArity();
            NodeTest test = node.getTest();
            RowData[] subsets = new RowData[arity];
            for (j = 0; j < arity; ++j) {
                subsets[j] = data.applyWeighted(test, j);
            }
            if (node != this.m_Root && this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoInodeStats)) {
                node.setClusteringStat(null);
                node.setTargetStat(null);
            }
            for (j = 0; j < arity; ++j) {
                ClusSplitNode child = new ClusSplitNode();
                node.setChild(child, j);
                child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsets[j]);
                child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsets[j]);
                this.induce(child, subsets[j]);
            }
        } else {
            ClusOptionNode optionNode = new ClusOptionNode();
            optionNode.setStatManager(this.m_StatManager);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("New option node.");
            }
            if (node != this.m_Root) {
                node.getParent().setChild(node.getParent().getChildIndex(node), optionNode);
            } else {
                optionNode.setClusteringStat(this.m_Root.getClusteringStat());
                optionNode.setTargetStat(this.m_Root.getTargetStat());
                this.m_Root = optionNode;
            }
            optionNode.setHeuristicRatios(new double[candidates.size()]);
            for (i = 0; i < candidates.size(); ++i) {
                int j;
                TestAndHeuristic tnh = (TestAndHeuristic)candidates.get(i);
                ClusSplitNode newNode = new ClusSplitNode();
                newNode.setStatManager(this.m_StatManager);
                optionNode.addChild(newNode);
                optionNode.setHeuristicRatio(i, tnh.getHeuristicValue() / bestTest.getHeuristicValue());
                newNode.testToNode(tnh);
                if (this.getSettings().getGeneral().getVerbose() > 0) {
                    ClusLogger.info("Test: " + newNode.getTestString() + " -> " + tnh.getHeuristicValue());
                }
                newNode.setTest(tnh.updateTest());
                newNode.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), data);
                newNode.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), data);
                int arity = newNode.updateArity();
                RowData[] subsets = new RowData[arity];
                for (j = 0; j < arity; ++j) {
                    subsets[j] = data.applyWeighted(newNode.getTest(), j);
                }
                for (j = 0; j < arity; ++j) {
                    ClusSplitNode child = new ClusSplitNode();
                    newNode.setChild(child, j);
                    child.setStatManager(this.m_StatManager);
                    child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsets[j]);
                    child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsets[j]);
                    this.induce(child, subsets[j]);
                }
            }
        }
    }

    private ClusAttrType[] getDescriptiveAttributes() {
        ClusSchema schema = this.getSchema();
        return schema.getDescriptiveAttributes();
    }

    private MyNode induceSingleUnpruned(RowData data) throws ClusException, IOException {
        do {
            this.m_Root = new ClusSplitNode();
            this.m_Root.initClusteringStat(this.m_StatManager, data);
            this.m_Root.initTargetStat(this.m_StatManager, data);
            this.m_Root.getClusteringStat().showRootInfo();
            this.induce((ClusSplitNode)this.m_Root, data);
        } while (SettingsGeneric.EXACT_TIME);
        return this.m_Root;
    }

    @Override
    public void induceAll(ClusRun cr) throws ClusException, IOException, InterruptedException {
        ClusModelInfo def_info = cr.addModelInfo(0);
        def_info.setModel(ClusDecisionTree.induceDefault(cr));
        ClusModel model = this.induceSingleUnpruned(cr);
        ClusModelInfo model_info = cr.addModelInfo(1);
        model_info.setModel(model);
    }

    private boolean initSelectorAndStopCrit(ClusSplitNode node, RowData data) {
        int max = this.getSettings().getConstraints().getTreeMaxDepth();
        if (max != -1 && node.getLevel() >= max) {
            return true;
        }
        return this.getSettings().getModel().getMinimalNbExamples() > 0 && data.getSumWeights() < (double)this.getSettings().getModel().getMinimalNbExamples();
    }

    private void initSelectorAndSplit(ClusStatistic stat) throws ClusException {
        this.m_FindBestTests.initSelectorAndSplit(stat);
    }

    private void setInitialData(ClusStatistic stat, RowData data) throws ClusException {
        this.m_FindBestTests.setInitialData(stat, data);
    }
}

