/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.util.exception.ClusException;

public class ILevelConstraint
implements Serializable {
    public static final int ILevelCMustLink = 0;
    public static final int ILevelCCannotLink = 1;
    protected int m_Type;
    protected DataTuple m_T1;
    protected DataTuple m_T2;

    public ILevelConstraint(DataTuple t1, DataTuple t2, int type) {
        this.m_T1 = t1;
        this.m_T2 = t2;
        this.m_Type = type;
    }

    public DataTuple getT1() {
        return this.m_T1;
    }

    public DataTuple getT2() {
        return this.m_T2;
    }

    public int getType() {
        return this.m_Type;
    }

    public int getOtherTupleIdx(DataTuple tuple) {
        return tuple == this.m_T1 ? this.m_T2.getIndex() : this.m_T1.getIndex();
    }

    public boolean isSideOne(DataTuple tuple) {
        return tuple == this.m_T1;
    }

    public static void loadConstraints(String fname, ArrayList constr, ArrayList points) throws IOException {
        LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));
        String line = rdr.readLine();
        while (line != null) {
            StringTokenizer tokens = new StringTokenizer(line, "\t");
            int t1 = Integer.parseInt(tokens.nextToken());
            int t2 = Integer.parseInt(tokens.nextToken());
            int type = Integer.parseInt(tokens.nextToken()) == 1 ? 0 : 1;
            constr.add(new ILevelConstraint((DataTuple)points.get(t1), (DataTuple)points.get(t2), type));
            line = rdr.readLine();
        }
        rdr.close();
    }

    public static ArrayList loadConstraints(String fname, ArrayList points) throws ClusException {
        ArrayList constr = new ArrayList();
        try {
            ILevelConstraint.loadConstraints(fname, constr, points);
            return constr;
        }
        catch (IOException e) {
            throw new ClusException("Error opening '" + fname + "': " + e.getMessage());
        }
    }
}

