/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.PrintWriter;
import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;

public class ILevelCRandIndex
extends ClusError {
    public static final long serialVersionUID = 1L;
    protected double m_RandIndex;
    protected boolean m_Invalid;
    protected boolean m_IsComputed;
    protected NominalAttrType m_Attr;
    protected ArrayList m_Exs = new ArrayList();
    protected int m_Count;

    public ILevelCRandIndex(ClusErrorList par, NominalAttrType nom) {
        super(par, 1);
        this.m_Attr = nom;
    }

    public double computeRandIndex() {
        int a = 0;
        int b = 0;
        int nbex = this.m_Exs.size();
        if (nbex == 0) {
            return 0.0;
        }
        for (int i = 0; i < nbex; ++i) {
            int[] ti = (int[])this.m_Exs.get(i);
            for (int j = i + 1; j < nbex; ++j) {
                int[] tj = (int[])this.m_Exs.get(j);
                if (ti[0] == tj[0] && ti[1] == tj[1]) {
                    ++a;
                }
                if (ti[0] == tj[0] || ti[1] == tj[1]) continue;
                ++b;
            }
        }
        double rand = 1.0 * (double)(a + b) / (double)(nbex * (nbex - 1) / 2);
        ClusLogger.info("Rand = " + rand + " (nbex = " + nbex + ")");
        return rand;
    }

    public boolean isInvalid() {
        return this.m_Invalid;
    }

    public double getRandIndex() {
        if (!this.m_IsComputed) {
            this.m_RandIndex = this.computeRandIndex();
            this.m_IsComputed = true;
        }
        return this.m_RandIndex;
    }

    @Override
    public void reset() {
        this.m_IsComputed = false;
        this.m_Exs.clear();
    }

    @Override
    public void add(ClusError other) {
        ILevelCRandIndex ri = (ILevelCRandIndex)other;
        if (!ri.isInvalid()) {
            this.m_RandIndex += ri.getRandIndex();
            ++this.m_Count;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
        this.m_Invalid = true;
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        this.m_IsComputed = false;
        int[] store = new int[2];
        ILevelCStatistic ilstat = (ILevelCStatistic)pred;
        store[0] = this.m_Attr.getNominal(tuple);
        store[1] = ilstat.getClusterID();
        this.m_Exs.add(store);
    }

    @Override
    public double getModelErrorComponent(int i) {
        if (this.m_Count > 0) {
            return this.m_RandIndex / (double)this.m_Count;
        }
        return this.getRandIndex();
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        if (this.isInvalid()) {
            out.println("?");
        } else if (this.m_Count > 0) {
            out.println(String.valueOf(1.0 * this.m_RandIndex / (double)this.m_Count) + " (cnt = " + this.m_Count + ")");
        } else {
            out.println(this.getRandIndex());
        }
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new ILevelCRandIndex(this.getParent(), this.m_Attr);
    }

    @Override
    public String getName() {
        return "Rand index";
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

