/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.main.ClusStatManager;

public class COPKMeansCluster
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected int m_Index;
    protected ClusStatManager m_Mgr;
    protected ArrayList<DataTuple> m_Data = new ArrayList();
    protected ILevelCStatistic m_Center;

    public COPKMeansCluster(DataTuple tuple, ClusStatManager mgr) {
        this.m_Mgr = mgr;
        this.m_Data.add(tuple);
        this.m_Center = (ILevelCStatistic)mgr.getStatistic(ClusAttrType.AttributeUseType.Clustering).cloneStat();
        this.updateCenter();
    }

    public ILevelCStatistic getCenter() {
        return this.m_Center;
    }

    public ClusStatManager getStatManager() {
        return this.m_Mgr;
    }

    public void clearData() {
        this.m_Data.clear();
    }

    public void addData(DataTuple tuple) {
        this.m_Data.add(tuple);
    }

    public void updateCenter() {
        this.m_Center.reset();
        for (int i = 0; i < this.m_Data.size(); ++i) {
            DataTuple tuple = this.m_Data.get(i);
            this.m_Center.updateWeighted(tuple, tuple.getWeight());
        }
        this.m_Center.calcMean();
    }

    public double computeDistance(DataTuple tuple) {
        double dist = 0.0;
        double[] num = this.m_Center.getNumericPred();
        for (int j = 0; j < this.m_Center.getNbAttributes(); ++j) {
            NumericAttrType att = this.m_Center.getAttribute(j);
            double v1 = num[j];
            double v2 = tuple.getDoubleVal(att.getArrayIndex());
            dist += (v1 - v2) * (v1 - v2);
        }
        return Math.sqrt(dist);
    }

    public void setIndex(int i) {
        this.m_Index = i;
        this.m_Center.setClusterID(i);
    }
}

