/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusNormalizedAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ilevelc.COPKMeansCluster;
import si.ijs.kt.clus.ext.ilevelc.COPKMeansModel;
import si.ijs.kt.clus.ext.ilevelc.DerivedConstraintsComputer;
import si.ijs.kt.clus.ext.ilevelc.ILevelCUtil;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.jeans.util.DisjointSetForest;

public class COPKMeans {
    protected int m_K;
    protected RowData m_Data;
    protected RowData m_OrigData;
    protected ClusStatManager m_Mgr;
    protected ArrayList<ILevelConstraint> m_Constraints;
    protected int[][] m_ConstraintsIndex;
    protected COPKMeansCluster[] m_Clusters;
    protected ClusNormalizedAttributeWeights m_Scale;

    public COPKMeans(int maxNbClasses, ClusStatManager mgr) {
        this.m_K = maxNbClasses;
        this.m_Mgr = mgr;
        this.m_Scale = (ClusNormalizedAttributeWeights)mgr.getClusteringWeights();
    }

    public ClusStatManager getStatManager() {
        return this.m_Mgr;
    }

    public void createInitialClusters(RowData data, ArrayList constr) {
        this.m_OrigData = data;
        this.m_Clusters = new COPKMeansCluster[this.m_K];
        ArrayList<DataTuple> points = data.toArrayList();
        DerivedConstraintsComputer comp = new DerivedConstraintsComputer(points, constr);
        comp.indexPoints();
        DisjointSetForest dsf = comp.createDSFWithMustLinks();
        ArrayList[] comps = comp.assignPointsToComponents(dsf);
        HashSet<int[]> set = comp.createCannotLinkSet(dsf);
        ClusSchema schema = data.getSchema();
        RowData new_data = new RowData(schema, comps.length);
        NominalAttrType classtype = (NominalAttrType)schema.getAttrType(schema.getNbAttributes() - 1);
        ClusStatManager mgr = this.getStatManager();
        RegressionStat stat = (RegressionStat)mgr.getStatistic(ClusAttrType.AttributeUseType.Clustering);
        for (int i = 0; i < comps.length; ++i) {
            DataTuple elem;
            ArrayList crcomp = comps[i];
            RegressionStat avg = (RegressionStat)stat.cloneStat();
            for (int j = 0; j < crcomp.size(); ++j) {
                elem = (DataTuple)crcomp.get(j);
                avg.updateWeighted(elem, elem.getWeight());
                elem.setIndex(i);
            }
            avg.calcMean();
            DataTuple tuple = new DataTuple(schema);
            tuple.setWeight(avg.getTotalWeight());
            for (int j = 0; j < avg.getNbAttributes(); ++j) {
                NumericAttrType att = avg.getAttribute(j);
                tuple.setDoubleVal(avg.getMean(j), att.getArrayIndex());
            }
            elem = (DataTuple)crcomp.get(0);
            classtype.setNominal(tuple, classtype.getNominal(elem));
            new_data.setTuple(tuple, i);
        }
        new_data.addIndices();
        this.m_Data = new_data;
        this.m_Constraints = new ArrayList();
        for (int[] edge : set) {
            DataTuple tj = new_data.getTuple(edge[0]);
            DataTuple tk = new_data.getTuple(edge[1]);
            this.m_Constraints.add(new ILevelConstraint(tj, tk, 1));
        }
        this.m_ConstraintsIndex = ILevelCUtil.createConstraintsIndex(new_data.getNbRows(), this.m_Constraints);
        boolean[] used_tuples = new boolean[new_data.getNbRows()];
        int nb_has = 0;
        while (nb_has < this.m_K) {
            int pi;
            int t2i;
            int t1i;
            ArrayList<ILevelConstraint> poss_constr = new ArrayList<ILevelConstraint>();
            for (int i = 0; i < this.m_Constraints.size(); ++i) {
                ILevelConstraint ilc = this.m_Constraints.get(i);
                t1i = ilc.getT1().getIndex();
                t2i = ilc.getT2().getIndex();
                int extra_pts = 0;
                if (!used_tuples[t1i]) {
                    ++extra_pts;
                }
                if (!used_tuples[t2i]) {
                    ++extra_pts;
                }
                if (extra_pts <= 0 || nb_has + extra_pts > this.m_K) continue;
                poss_constr.add(ilc);
            }
            if (poss_constr.size() > 0) {
                int ci = ClusRandom.nextInt(4, poss_constr.size());
                ILevelConstraint ilc = (ILevelConstraint)poss_constr.get(ci);
                t1i = ilc.getT1().getIndex();
                t2i = ilc.getT2().getIndex();
                if (!used_tuples[t1i]) {
                    used_tuples[t1i] = true;
                    this.m_Clusters[nb_has++] = new COPKMeansCluster(new_data.getTuple(t1i), mgr);
                }
                if (used_tuples[t2i]) continue;
                used_tuples[t2i] = true;
                this.m_Clusters[nb_has++] = new COPKMeansCluster(new_data.getTuple(t2i), mgr);
                continue;
            }
            ArrayList<DataTuple> poss_pts = new ArrayList<DataTuple>();
            for (int i = 0; i < used_tuples.length; ++i) {
                if (used_tuples[i]) continue;
                poss_pts.add(new_data.getTuple(i));
            }
            if (poss_pts.size() > 0) {
                pi = ClusRandom.nextInt(4, poss_pts.size());
                DataTuple sel_pt = (DataTuple)poss_pts.get(pi);
                used_tuples[sel_pt.getIndex()] = true;
                this.m_Clusters[nb_has++] = new COPKMeansCluster(sel_pt, mgr);
                continue;
            }
            pi = ClusRandom.nextInt(4, used_tuples.length);
            this.m_Clusters[nb_has++] = new COPKMeansCluster(new_data.getTuple(pi), mgr);
        }
    }

    public void numberClusters() {
        for (int i = 0; i < this.m_K; ++i) {
            this.m_Clusters[i].setIndex(i);
        }
    }

    public void clearDataFromClusters() {
        for (int i = 0; i < this.m_K; ++i) {
            this.m_Clusters[i].clearData();
        }
    }

    public void updateClusterCenters() {
        for (int i = 0; i < this.m_K; ++i) {
            this.m_Clusters[i].updateCenter();
        }
    }

    public double computeVariance() {
        double variance = 0.0;
        for (int i = 0; i < this.m_K; ++i) {
            variance += this.m_Clusters[i].getCenter().getSVarS(this.m_Scale);
        }
        return variance;
    }

    public boolean checkConstraints(DataTuple tuple, int clid, int[] assign) {
        int[] cidx = this.m_ConstraintsIndex[tuple.getIndex()];
        if (cidx != null) {
            for (int j = 0; j < cidx.length; ++j) {
                ILevelConstraint cons = this.m_Constraints.get(cidx[j]);
                int otidx = cons.getOtherTupleIdx(tuple);
                int oclid = assign[otidx];
                if (clid != oclid) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean assignDataToClusters(int[] assign) {
        for (int i = 0; i < this.m_Data.getNbRows(); ++i) {
            int best_cl = -1;
            double min_dist = Double.POSITIVE_INFINITY;
            DataTuple tuple = this.m_Data.getTuple(i);
            for (int j = 0; j < this.m_K; ++j) {
                double dist;
                boolean ok = this.checkConstraints(tuple, j, assign);
                if (!ok || !((dist = this.m_Clusters[j].computeDistance(tuple)) < min_dist)) continue;
                best_cl = j;
                min_dist = dist;
            }
            if (best_cl == -1) {
                return false;
            }
            assign[tuple.getIndex()] = best_cl;
            this.m_Clusters[best_cl].addData(tuple);
        }
        return true;
    }

    public double computeRandIndex(int[] assign) {
        int a = 0;
        int b = 0;
        int nbex = this.m_OrigData.getNbRows();
        ClusSchema schema = this.m_OrigData.getSchema();
        NominalAttrType classtype = (NominalAttrType)schema.getAttrType(schema.getNbAttributes() - 1);
        for (int i = 0; i < nbex; ++i) {
            DataTuple ti = this.m_OrigData.getTuple(i);
            int cia = classtype.getNominal(ti);
            int cib = assign[this.m_Data.getTuple(ti.getIndex()).getIndex()];
            for (int j = i + 1; j < nbex; ++j) {
                DataTuple tj = this.m_OrigData.getTuple(j);
                int cja = classtype.getNominal(tj);
                int cjb = assign[this.m_Data.getTuple(tj.getIndex()).getIndex()];
                if (cia == cja && cib == cjb) {
                    ++a;
                }
                if (cia == cja || cib == cjb) continue;
                ++b;
            }
        }
        double rand = 1.0 * (double)(a + b) / (double)(nbex * (nbex - 1) / 2);
        ClusLogger.info("Rand = " + rand + " (nbex = " + nbex + ")");
        return rand;
    }

    public ClusModel induce(RowData data, ArrayList constr) {
        COPKMeansModel model = new COPKMeansModel();
        model.setK(this.m_K);
        this.createInitialClusters(data, constr);
        this.numberClusters();
        int[] prev_assign = null;
        int[] assign = new int[this.m_Data.getNbRows()];
        for (int k = 0; k < 1000000; ++k) {
            this.clearDataFromClusters();
            Arrays.fill(assign, -1);
            if (!this.assignDataToClusters(assign)) {
                model.setIllegal(true);
                return model;
            }
            this.updateClusterCenters();
            if (prev_assign != null && Arrays.equals(assign, prev_assign)) {
                model.setIterations(k + 1);
                break;
            }
            if (prev_assign == null) {
                prev_assign = new int[this.m_Data.getNbRows()];
            }
            System.arraycopy(assign, 0, prev_assign, 0, this.m_Data.getNbRows());
        }
        this.clearDataFromClusters();
        model.setClusters(this.m_Clusters);
        model.setRandIndex(this.computeRandIndex(assign));
        return model;
    }
}

