/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical.thresholdcalibration;

import java.util.LinkedHashMap;
import si.ijs.kt.clus.ext.hierarchical.thresholdcalibration.HierThresholdCalibration;
import si.ijs.kt.clus.statistic.WHTDStatistic;

public class calibrateByLabelCardinality
implements HierThresholdCalibration {
    double m_Step;
    double m_labelCardinalityTrain;
    int nbExamples;
    LinkedHashMap<Double, Integer> cardinalities;

    public calibrateByLabelCardinality(double step, double labelCardinalityTrain) {
        this.m_Step = step;
        this.m_labelCardinalityTrain = labelCardinalityTrain;
        this.nbExamples = 0;
        this.cardinalities = new LinkedHashMap();
        this.cardinalities.put(100.0, 0);
        for (double d = 100.0 - this.m_Step; d > 0.0; d -= this.m_Step) {
            this.cardinalities.put(d, 0);
        }
        this.cardinalities.put(0.0, 0);
    }

    @Override
    public double getThreshold() {
        double bestThreshold = 0.0;
        double bestCardinality = Double.MAX_VALUE;
        for (double threshold : this.cardinalities.keySet()) {
            double tempCardinality = 1.0 * (double)this.cardinalities.get(threshold).intValue() / (double)this.nbExamples;
            if (!(Math.abs(1.0 * (double)this.cardinalities.get(threshold).intValue() / (double)this.nbExamples - this.m_labelCardinalityTrain) < Math.abs(bestCardinality - this.m_labelCardinalityTrain))) continue;
            bestThreshold = threshold;
            bestCardinality = tempCardinality;
        }
        return bestThreshold;
    }

    @Override
    public void addExample(WHTDStatistic stat) {
        for (double threshold : this.cardinalities.keySet()) {
            stat.setThreshold(threshold);
            stat.computePrediction();
            this.cardinalities.put(threshold, this.cardinalities.get(threshold) + stat.getNbPredictedClasses());
        }
        ++this.nbExamples;
    }

    public double getCardinality(double th) {
        return 1.0 * (double)this.cardinalities.get(th).intValue() / (double)this.nbExamples;
    }
}

