/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class HierRemoveInsigClasses
extends PruneTree {
    PruneTree m_Pruner;
    ClusData m_PruneSet;
    ClassHierarchy m_Hier;
    boolean m_NoRoot;
    boolean m_UseBonferroni;
    double m_SigLevel;
    int m_Bonferroni;

    public HierRemoveInsigClasses(ClusData pruneset, PruneTree other, boolean bonf, ClassHierarchy hier) {
        this.m_Pruner = other;
        this.m_PruneSet = pruneset;
        this.m_Hier = hier;
        this.m_UseBonferroni = bonf;
    }

    @Override
    public int getNbResults() {
        return 1;
    }

    public void setNoRootPreds(boolean noroot) {
        this.m_NoRoot = noroot;
    }

    public void setSignificance(double siglevel) {
        this.m_SigLevel = siglevel;
    }

    @Override
    public void prune(ClusNode node) throws ClusException {
        this.m_Pruner.prune(node);
        if (this.m_SigLevel != 0.0 && this.m_PruneSet.getNbRows() != 0) {
            WHTDStatistic global = (WHTDStatistic)node.getTargetStat().cloneStat();
            this.m_PruneSet.calcTotalStat(global);
            global.calcMean();
            this.m_Bonferroni = this.computeNRecursive(node);
            this.executeRecursive(node, global, (RowData)this.m_PruneSet);
        }
    }

    public int computeNRecursive(ClusNode node) {
        int result = 0;
        if (node.atBottomLevel()) {
            WHTDStatistic stat = (WHTDStatistic)node.getTargetStat();
            result += stat.getNbPredictedClasses();
        }
        for (int i = 0; i < node.getNbChildren(); ++i) {
            result += this.computeNRecursive((ClusNode)node.getChild(i));
        }
        return result;
    }

    public void executeRecursive(ClusNode node, WHTDStatistic global, RowData data) {
        int arity = node.getNbChildren();
        for (int i = 0; i < arity; ++i) {
            RowData subset = data.applyWeighted(node.getTest(), i);
            this.executeRecursive((ClusNode)node.getChild(i), global, subset);
        }
        WHTDStatistic orig = (WHTDStatistic)node.getTargetStat();
        WHTDStatistic valid = (WHTDStatistic)orig.cloneStat();
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            valid.updateWeighted(tuple, i);
        }
        valid.calcMean();
        WHTDStatistic pred = (WHTDStatistic)orig.cloneStat();
        pred.copy(orig);
        pred.setValidationStat(valid);
        pred.setGlobalStat(global);
        if (this.m_UseBonferroni) {
            pred.setSigLevel(this.m_SigLevel / (double)this.m_Bonferroni);
        } else {
            pred.setSigLevel(this.m_SigLevel);
        }
        pred.calcMean();
        node.setTargetStat(pred);
    }
}

