/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.util.array.MDoubleArray;

public class HierMatrixOutput {
    public static void writeExamples(RowData data, ClassHierarchy hier) {
        try {
            PrintWriter wrt = data.getSchema().getSettings().getGeneric().getFileAbsoluteWriter("examples.matrix");
            HierMatrixOutput.writeHeader(hier, wrt);
            ClassesAttrType type = hier.getType();
            int sidx = type.getArrayIndex();
            double[] vector = new double[hier.getTotal()];
            for (int i = 0; i < data.getNbRows(); ++i) {
                Arrays.fill(vector, 0.0);
                DataTuple tuple = data.getTuple(i);
                ClassesTuple tp = (ClassesTuple)tuple.getObjVal(sidx);
                for (int j = 0; j < tp.getNbClasses(); ++j) {
                    ClassesValue val = tp.getClass(j);
                    vector[val.getIndex()] = 1.0;
                }
                wrt.println(MDoubleArray.toString(vector));
            }
            wrt.close();
        }
        catch (IOException e) {
            ClusLogger.info("Error: " + e.getMessage());
        }
    }

    public static void writeHeader(ClassHierarchy hier, PrintWriter wrt) {
        wrt.print("[");
        for (int i = 0; i < hier.getTotal(); ++i) {
            if (i != 0) {
                wrt.print(",");
            }
            wrt.print(String.valueOf(hier.getWeight(i)));
        }
        wrt.println("]");
    }
}

