/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.TuplePreproc;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClassHierarchyPreproc
implements TuplePreproc {
    protected ClassesAttrType m_Type;
    protected boolean m_IsSinglePass;
    protected boolean m_AddIntermediates;
    protected transient boolean[] m_Intermediates;
    protected transient ArrayList m_Scratch;

    public ClassHierarchyPreproc(ClassesAttrType type, boolean addinter) {
        this.m_Type = type;
        this.m_IsSinglePass = type.getHier().isLocked();
        this.m_AddIntermediates = addinter;
        if (addinter && this.m_IsSinglePass) {
            this.createScratch();
        }
    }

    public boolean isAddIntermediateClasses() {
        return this.m_AddIntermediates;
    }

    public boolean isSinglePass() {
        return this.m_IsSinglePass;
    }

    public final ClassHierarchy getHier() {
        return this.m_Type.getHier();
    }

    @Override
    public int getNbPasses() {
        return this.isSinglePass() ? 1 : 2;
    }

    @Override
    public void preproc(int pass, DataTuple tuple) throws ClusException {
        ClassesTuple ct = (ClassesTuple)tuple.getObjVal(this.m_Type.getArrayIndex());
        if (ct.toString().contains("?")) {
            tuple.setObjectVal(new ClassesTuple(ClassesValue.EMPTY_SET_INDICATOR, null), this.m_Type.getArrayIndex());
            ct = (ClassesTuple)tuple.getObjVal(this.m_Type.getArrayIndex());
        }
        if (!this.isSinglePass() && pass == 0) {
            ct.addToHierarchy(this.getHier());
        } else {
            ct.addHierarchyIndices(this.getHier());
            if (this.isAddIntermediateClasses()) {
                this.addIntermediateElems(ct);
            }
        }
    }

    @Override
    public void preprocSingle(DataTuple tuple) throws ClusException {
        ClassesTuple ct = (ClassesTuple)tuple.getObjVal(this.m_Type.getArrayIndex());
        ct.addHierarchyIndices(this.getHier());
        if (this.isAddIntermediateClasses()) {
            this.addIntermediateElems(ct);
        }
    }

    @Override
    public void done(int pass) throws ClusException {
        if (pass > 0) {
            return;
        }
        if (!this.isSinglePass()) {
            this.getHier().initialize();
            if (this.isAddIntermediateClasses()) {
                this.createScratch();
            }
        }
    }

    private void createScratch() {
        this.m_Intermediates = new boolean[this.getHier().getTotal()];
        this.m_Scratch = new ArrayList();
    }

    private void addIntermediateElems(ClassesTuple ct) throws ClusException {
        Arrays.fill(this.m_Intermediates, false);
        ct.addIntermediateElems(this.getHier(), this.m_Intermediates, this.m_Scratch);
        this.m_Scratch.clear();
    }
}

