/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief.statistics;

import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.featureRanking.relief.ClusReliefFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Statistics;
import si.ijs.kt.clus.util.exception.ClusException;

public class DistanceSimplified
extends Statistics {
    private double[][][] m_SumDistAttrTarget;
    private double[] tempSumDistAttrTarget;
    private static double EPS = 0.01;

    public DistanceSimplified(ClusReliefFeatureRanking relief, int nbTargets, int nbDiffNbNeighbours, int nbDescriptiveAttributes) {
        this.initializeSuperFields(relief, nbDescriptiveAttributes);
        this.m_SumDistAttrTarget = new double[nbTargets][nbDiffNbNeighbours][nbDescriptiveAttributes];
        this.tempSumDistAttrTarget = new double[nbDescriptiveAttributes];
    }

    @Override
    public void updateTempStatistics(int targetIndex, boolean isStdClassification, DataTuple tuple, RowData data, NearestNeighbour neigh, double neighWeightNonnormalized, int trueIndex, int targetValue) throws ClusException {
        double targetDistance = 0.0;
        targetDistance = targetIndex >= 0 && !isStdClassification ? this.mRelief.computeDistance1D(tuple, data.getTuple(neigh.getIndexInDataset()), this.mRelief.getTargetAttribute(trueIndex)) : this.mRelief.computeDistance(tuple, data.getTuple(neigh.getIndexInDataset()), 1);
        int attrInd = 0;
        while (attrInd < this.m_NbDescriptiveAttrs) {
            ClusAttrType attr = this.mRelief.getDescriptiveAttribute(attrInd);
            double distAttr = this.mRelief.computeDistance1D(tuple, data.getTuple(neigh.getIndexInDataset()), attr);
            int n = attrInd++;
            this.tempSumDistAttrTarget[n] = this.tempSumDistAttrTarget[n] + 1.0 / (targetDistance + EPS) * -distAttr * neighWeightNonnormalized;
        }
    }

    @Override
    public void updateStatistics(int targetIndex, int numNeighInd, double sumNeighbourWeights) {
        for (int attrInd = 0; attrInd < this.m_NbDescriptiveAttrs; ++attrInd) {
            double[] dArray = this.m_SumDistAttrTarget[targetIndex + 1][numNeighInd];
            int n = attrInd;
            dArray[n] = dArray[n] + this.tempSumDistAttrTarget[attrInd] / sumNeighbourWeights;
        }
    }

    @Override
    public void resetTempFields() {
        Arrays.fill(this.tempSumDistAttrTarget, 0.0);
    }

    @Override
    public double computeImportances(int targetIndex, int nbNeighInd, int attrInd, boolean isStdClassification, double[] successfulItearions) {
        return this.m_SumDistAttrTarget[targetIndex + 1][nbNeighInd][attrInd] / successfulItearions[targetIndex + 1];
    }
}

