/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NearestNeighbour {
    private final int m_indexInDataSet;
    private double m_descriptiveDistance = Double.NaN;
    @Deprecated
    private double m_targetDistance = Double.NaN;

    @Deprecated
    public NearestNeighbour(int index, double desDist, double tarDist) {
        this.m_indexInDataSet = index;
        this.m_descriptiveDistance = desDist;
        this.m_targetDistance = tarDist;
    }

    public NearestNeighbour(int index, double desDist) {
        this.m_indexInDataSet = index;
        this.m_descriptiveDistance = desDist;
    }

    public NearestNeighbour(String nnFileString) {
        Pattern nnPatern = Pattern.compile("NN[(]([^;]+);([^;]+)[)]");
        Matcher nnParsed = nnPatern.matcher(nnFileString);
        if (!nnParsed.find()) {
            throw new RuntimeException(String.format("Nearest neighbour %s could not be parsed.", nnFileString));
        }
        this.m_indexInDataSet = Integer.parseInt(nnParsed.group(1));
        this.m_descriptiveDistance = Double.parseDouble(nnParsed.group(2).replace(",", "."));
    }

    public String toFileString() {
        return String.format("NN(%d;%f)", this.m_indexInDataSet, this.m_descriptiveDistance);
    }

    public String toString() {
        return String.format("NN(%d)", this.m_indexInDataSet);
    }

    public int getIndexInDataset() {
        return this.m_indexInDataSet;
    }

    public double getDescriptiveDidstance() {
        return this.m_descriptiveDistance;
    }

    @Deprecated
    public double getTargetDistance() {
        return this.m_targetDistance;
    }

    @Deprecated
    public void setTargetDistance(double dist) {
        this.m_targetDistance = dist;
    }

    public boolean equals(Object other) {
        if (other instanceof NearestNeighbour) {
            return this.m_indexInDataSet == ((NearestNeighbour)other).m_indexInDataSet;
        }
        return false;
    }
}

